/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef SOQT
#  include <Inventor/Qt/viewers/SoQtConstrainedViewer.h>
#elif defined _WIN32
#  include <Inventor/Win/viewers/SoWinConstrainedViewer.h>
#else // _WIN32

#ifndef  _SO_XT_CONSTRAINED_VIEWER_
#define  _SO_XT_CONSTRAINED_VIEWER_

#include <Inventor/Xt/viewers/SoXtFullViewer.h>
#include <Inventor/SbBox.h>
#include <Inventor/Gui/viewers/SoGuiConstrainedViewer.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoXtConstrainedViewer
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Base viewer class which adds camera constraints given a world up direction.
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This is a base class for the SoXtWalkViewer and SoXtFlyViewer component viewers.
 *   This class adds methods and convenience routines available to subclasses to
 *   constrain the camera given a world up direction. This prevents the camera from
 *   looking upside down. By default the +Y direction is used.
 * 
 * @SEE_ALSO
 *    SoXtFullViewer,
 *    SoXtViewer,
 *    SoXtComponent,
 *    SoXtRenderArea,
 *    SoXtWalkViewer,
 *    SoXtFlyViewer
 * 
 * 
 */
class INVENTORXT_API SoXtConstrainedViewer : public SoXtFullViewer 
{
 public:
    
  /**
   * Specifies the upward direction of the viewer. This up direction is used by the
   * viewers to constrain the camera when tilting up/down, and also used when
   * rotating the camera right/left. The default is the +Y (0,1,0) direction.
   */
  void setUpDirection ( const SbVec3f& newUpDirection );
  /**
   * Returns the upward direction of the viewer.
   */
  SbVec3f getUpDirection() { return m_guiConstViewer->getUpDirection(); }
    
  //
  // redefine these to add constrained viewer functionality
  //
  virtual void setCamera( SoCamera* newCam );
  virtual void saveHomePosition();
  virtual void resetToHomePosition();
  virtual void recomputeSceneSize();

  SoINTERNAL public:
  SoGuiConstrainedViewer* getGuiConstrainedViewer() const;

  // Retro compatibility only
  SbVec3f upDirection;
  float sceneHeight, sceneSize;
    
 protected:
  SoXtConstrainedViewer( SoWidget parent,
                         const char* name, 
                         SbBool buildInsideParent, 
                         SoXtFullViewer::BuildFlag flag, 
                         SoXtViewer::Type type, 
                         SbBool buildNow,
                         SbBool sync = TRUE );
    
  SoXtConstrainedViewer( SoWidget parent,
                         const char* name, 
                         SbBool buildInsideParent, 
                         SoXtFullViewer::BuildFlag flag, 
                         SoXtViewer::Type type, 
                         SbBool buildNow,
                         SbBool sync,
                         SoGuiConstrainedViewer* guiConstViewer );

  ~SoXtConstrainedViewer();
    
  // Tilts the camera, restraining it to 180 degree rotation from the
  // up direction. A positive angle tilts the camera up.
  virtual void tiltCamera( float deltaAngle );
    
  // Redefine these to do constrained viewing tasks.
  // The bottom wheel rotates the camera around the up direction, the
  // left wheel tilts the camera up/down constraning to 180 degree from
  // the up direction. 
  virtual void bottomWheelMotion( float newVal );
  virtual void leftWheelMotion( float newVal );
    
  // This is called during a paste.
  // We redefine this to keep the right vector of the camera
  // in a parallel plane.
  virtual void changeCameraValues( SoCamera* newCamera );
    
  // this routine is called by subclasses to find and set the new
  // up direction given the current mouse position. If something is
  // picked, the normal to the object picked will be used to specify
  // the new up direction.
  void findUpDirection( const SbVec2s& mouseLocation );
    
  // this routine checks the camera orientation and makes sure that the
  // current right vector and the ideal right vector (cross between the
  // view vector and world up direction) are the same (i.e. no unwanted
  // roll), else it fixes it. This keeps the up direction valid.
  void checkForCameraUpConstrain();
    
  // Redefine this to keep the up vector when seeking
  virtual void computeSeekFinalOrientation();
    
 private:
 
  void constructorCommon( SbBool buildNow );
  SoGuiConstrainedViewer* m_guiConstViewer; // Implementation class of SoXxConstrainedViewer

};

#endif  /* _SO_XT_CONSTRAINED_VIEWER_ */

#endif // _WIN32


