/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef SOQT
#  include <Inventor/Qt/viewers/SoQtPlaneViewer.h>
#elif defined _WIN32
#  include <Inventor/Win/viewers/SoWinPlaneViewer.h>
#else // _WIN32

#ifndef  _SO_XT_PLANE_VIEWER_
#define  _SO_XT_PLANE_VIEWER_

#include <Inventor/Xt/viewers/SoXtFullViewer.h>
#include <Inventor/SbLinear.h>

#include <Inventor/Gui/viewers/SoGuiPlaneViewer.h>

class SoXtBitmapButton;


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoXtPlaneViewer
//
//  Plane Viewer - allows the user to move the camera in a plane, zoom in
//      and out, as well as rotate the viewing plane.
//
//      Keys used by this viewer:
//      -------------------------
//
//     Left Mouse: Dolly in and out (gets closer to and further away from the
//     object).
//
//     Middle Mouse:
//     Ctrl + Left Mouse: Translate up, down, left and right.
//
//     Ctrl + Middle Mouse: Used for roll action (rotates around the viewer
//     forward direction).
//
//     \<s\> + click: Alternative to the Seek button. Press (but do not hold down)
//     the \<s\> key, then click on a target object.
//
//     Right Mouse: Open the popup menu.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Viewer component which moves the camera in a plane.
 *
 * @ingroup Xt
 *
 * @DESCRIPTION
 *   The Plane viewer component allows the user to translate the camera in the
 *   viewing plane, as well as dolly (move foward/backward) and zoom in and out. The
 *   viewer also allows the user to roll the camera (rotate around the forward
 *   direction) and seek to objects which will specify a new viewing plane. This
 *   viewer could be used for modeling, in drafting, and architectural work. The
 *   camera can be aligned to the X, Y or Z axes.
 *
 * @RESOURCES
 * \verbatim
     !!------------------------------------------------
     !! Decorations for Plane Viewer !!
     !!------------------------------------------------
     *IvPlaneTitle.labelString: Plane Viewer
     *IvPlanePrefTitle.labelString: Plane Viewer Preference Sheet
     *IvPlanePopupTitle.labelString: Plane Viewer
     *IvPlaneIconTitle.labelString: Plane Viewer
     *IvPlaneTransx.labelString: transX
     *IvPlaneTransy.labelString: transY
     *IvPlaneZoom.labelString: Zoom
     *IvPlaneDolly.labelString: Dolly
   \endverbatim
 *
 * @USAGE
 *  (For 3-button mouse only.)
 *
 *   @B Left Mouse or @BR
 *   Left + Middle Mouse: @b Dolly in and out (gets closer to and further away from
 *   the object) (Perspective camera) or zoom in and out (Orthographic camera).
 *
 *   @B Middle Mouse or @BR
 *   Ctrl + Left Mouse: @b Translate up, down, left and right.
 *
 *   @B Ctrl + Middle Mouse: @b Used for roll action (rotates around the viewer
 *   forward direction).
 *
 *   @B \<s\> + Left Mouse: @b Alternative to the Seek button. Press (but do not hold
 *   down) the \<s\> key, then click on a target object.
 *
 *   @B Right Mouse: @b Open the popup menu.
 *
 *   @B ALT: @b When the viewer is in selection (a.k.a. pick) mode, pressing and
 *   holding the ALT key temporarily switches the viewer to viewing mode. When the
 *   ALT key is released, the viewer returns to selection mode. Note: If any of the
 *   mouse buttons are currently depressed, the ALT key has no effect.
 *
 *   @B Mouse Wheel: @b Dolly/zoom camera @BR
 *   Rotating the mouse wheel does a camera "dolly" operation on a perspective camera 
 *   (moving the camera closer or farther away from the scene, which visually zoom) or
 *   a camera "zoom" operation on an orthographic camera (changing the view volume height).  
 *
 *   Note that many users find the default dolly speed with the mouse wheel to be too slow.
 *   The user can hold down the Shift key to make the mouse wheel dolly go 2X faster.
 *   To increase the base speed set the environment variable OIV_WHEEL_DELTA. Mouse wheel
 *   events contain a "delta" that is a multiple of 120. The viewer divides this value by
 *   OIV_WHEEL_DELTA to compute the camera dolly increment. The default value for 
 *   OIV_WHEEL_DELTA is 120. So, for example, setting OIV_WHEEL_DELTA to 12 makes the 
 *   mouse wheel dolly go 10X faster.
 *
 * @SEE_ALSO
 *    SoXtFullViewer,
 *    SoXtViewer,
 *    SoXtComponent,
 *    SoXtRenderArea,
 *    SoXtWalkViewer,
 *    SoXtExaminerViewer,
 *    SoXtFlyViewer
 *
 *
 */
class INVENTORXT_API SoXtPlaneViewer : public SoXtFullViewer
{
 public:
  /**
   * Constructor which specifies the viewer type. Please refer to the
   * SoXtViewer reference pages for a description of the viewer types.
   */
  SoXtPlaneViewer( SoWidget parent = NULL,
                   const char* name = NULL,
                   SbBool buildInsideParent = TRUE,
                   SoXtFullViewer::BuildFlag flag = SoXtFullViewer::BUILD_ALL,
                   SoXtViewer::Type type = SoXtViewer::BROWSER );
  /**
   * Destructor.
   */
  ~SoXtPlaneViewer();

  /**
   * Moves the camera to be aligned with the given plane
   */
  void setPlane( const SbVec3f& newNormal, const SbVec3f& newRight );

  // redefine these to add Plane viewer functionality
  virtual void setViewing( SbBool onOrOff );
  virtual void setCamera( SoCamera* cam );
  virtual void setCursorEnabled( SbBool onOrOff );
  virtual void setSeekMode( SbBool onOrOff );

  SoINTERNAL public:
    SoGuiPlaneViewer* getGuiPlaneViewer() const;

  // This constructor takes a boolean whether to build the widget now.
  // Subclasses can pass FALSE, then call SoXtPlaneViewer::buildWidget()
  // when they are ready for it to be built.
   SoEXTENDER public:
    SoXtPlaneViewer( SoWidget parent,
                     const char* name,
                     SbBool buildInsideParent,
                     SoXtFullViewer::BuildFlag flag,
                     SoXtViewer::Type type,
                     SbBool buildNow,
                     SbBool sync = TRUE );
 protected:

  SoWidget buildWidget( SoWidget parent );

  // redefine these
  virtual SbString getDefaultWidgetName() const;
  virtual SbString getDefaultTitle() const;
  virtual SbString getDefaultIconTitle() const;

  // redefine those routines to do viewer specific stuff
  virtual void processEvent( XAnyEvent* anyevent );
  virtual void actualRedraw();

  // Define those thumb wheels to translate in the viewer plane
  virtual void bottomWheelMotion( float newVal );
  virtual void leftWheelMotion( float newVal );
  virtual void rightWheelMotion( float newVal );

  // add viewer preference stuff
  virtual void createPrefSheet();

  // add some viewer buttons
  virtual void createViewerButtons( SoWidget parent );

  // Define this to bring the viewer help card
  virtual void openViewerHelpCard();

  // Redefine this to keep the same camera rotation when seeking
  virtual void computeSeekFinalOrientation();

  virtual void updateCursor();

 private:
  // viewer state variables
  Cursor transCursor, dollyCursor, seekCursor;

  // push button vars and callbacks
  SoXtBitmapButton* buttonList[10];
  static void pushButtonCB( SoWidget w, int id, void* data );

  void updateViewerMode( unsigned int state );
  void switchMode( int newMode );
  void defineCursors();

  // this is called by both constructors
  void constructorCommon( SbBool buildNow );

  SoGuiPlaneViewer* m_guiPlaneViewer; // Implementation class for SoXxPlaneViewer
};

#endif  /* _SO_XT_PLANE_VIEWER_ */

#endif // _WIN32


