/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : Damien Dallarosa (Nov 2009)
**=======================================================================*/


#ifndef _SO_BOX_HIGHLIGHT_RENDER_ACTION_
#define _SO_BOX_HIGHLIGHT_RENDER_ACTION_

#include <Inventor/actions/SoHighlightRenderAction.h>
#include <Inventor/actions/SoCallbackAction.h>

class SbColor;
class SoSeparator;
class SoNodeSensor;
class SoSensor;
class BoxHighlightCameraChecker;
class SbViewportRegion;


/**
 * A box highlight style.
 * 
 * @ingroup actions
 * 
 * @DESCRIPTION
 * SoBoxHighlightRenderAction is a render action which renders the specified scene
 * graph, then renders wireframe boxes surrounding each selected object.
 * If an SoGetBoundingBoxAction applied to a selected object produces an empty
 * bounding box, no highlight is rendered for that object.
 *
 * Selected objects are specified by the first selection node (SoSelection or
 * SoExtSelection) node in the scene to which this action is applied. If there is
 * no selection node in the scene graph, then no objects will be highlighted.
 *
 * The application must explicitly tell Open Inventor to use a highlight render
 * action in place of the default SoGLRenderAction in the SoSceneManager class
 * using the setGLRenderAction() method. The viewer classes provide a convenience
 * setGLRenderAction() method that calls SoSceneManager (see e.g. SoWinRenderArea).
 *
 * For convenience, the viewer classes also provide the redrawOnSelectionChange()
 * method. This method attaches a sensor to the specified selection node and
 * automatically schedules a redraw if the set of selected objects is modified.
 *
 * Other highlight effects are available including "halo" highlighting.
 *
 * @EXAMPLE
 *   Here is an example of how a box highlight can be specified for a particular
 *   selection node and viewer:
 *   \if_cpp
 *     \code
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *     . . .
 *     // Viewer
 *     SoWinExaminerViewer* viewer = new SoWinExaminerViewer();
 *     viewer->setSceneGraph( selectionNode );
 *
 *     // Set the highlight render action
 *     viewer->setGLRenderAction( new SoBoxHighlightRenderAction() );
 *    
 *     // Request automatic redraw when selection changes
 *     viewer->redrawOnSelectionChange( selectionNode );
 *     \endcode
 *   \endif
 *   \if_dotnet
 *     \code
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *     . . .
 *     // Viewer
 *     SoWinExaminerViewer viewer = new SoWinExaminerViewer();
 *     viewer.SetSceneGraph( selectionNode );
 *
 *     // Set the highlight render action
 *     viewer.SetGLRenderAction( new SoBoxHighlightRenderAction() );
 *    
 *     // Request automatic redraw when selection changes
 *     viewer.RedrawOnSelectionChange( selectionNode );
 *     \endcode
 *   \endif
 *   \if_java
 *     \code
 *     // Viewer
 *     ViewerExaminer viewer = new ViewerExaminer();
 *     // Set the highlight render action
 *     final RenderArea area = viewer.getRenderArea();
 *     area.setGLRenderAction( new SoBoxHighlightRenderAction() );
 *
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *
 *     // Request automatic redraw when selection changes
 *     selectionNode.addChangeCallback(new SoSelectionClassCB()
 *     {
 *       public void invoke(SoSelection s)
 *       {
 *         area.scheduleRedraw();
 *       }
 *     });
 *     . . .
 *     viewer.setSceneGraph( selectionNode );
 *
 *     \endcode
 *   \endif
 * 
 * @SEE_ALSO
 *    SoLineHighlightRenderAction,
 *    SoColorHighlightRenderAction,
 *    SoHaloHighlightRenderAction,
 *    SoHighlightRenderAction,
 *    SoGLRenderAction,
 *    SoSelection,
 *    SoWinRenderArea
 *
 *
 */
class INVENTOR_API SoBoxHighlightRenderAction : public SoHighlightRenderAction
{
  SO_ACTION_HEADER(SoBoxHighlightRenderAction);
  
 public:
  /**
   * Constructor.
   */
  SoBoxHighlightRenderAction();
  
  /**
   * Constructor which takes the normal SoGLRenderAction parameters.
   */
  SoBoxHighlightRenderAction(const SbViewportRegion &viewportRegion);

#ifndef HIDDEN_FROM_DOC  
  /**
   * Destructor
   */
  virtual ~SoBoxHighlightRenderAction();
#endif // HIDDEN_FROM_DOC

  /**
   * This renders the passed scene graph, and also renders wireframe boxes around
   * selected objects as specified by the first SoSelection node found in the scene
   * graph.
   */
  virtual void apply(SoNode *node);
  
  /**
   * Sets the color of the highlight. Default is red @B (1,0,0) @b.
   * Application is responsible for forcing a redraw of the scene to see the effects
   * of this change.
   */
  void setColor(const SbColor &c);
  /**
   * Gets the color of the highlight. 
   */
  const SbColor & getColor();
  /**
   * Sets the line pattern of the highlight. Default is solid, @B 0xffff @b.
   * The pattern of bits in the passed variable specifies the pattern of the line.
   * See SoDrawStyle for a description. Application is responsible for forcing a
   * redraw of the scene to see the effects of this change.
   */
  void setLinePattern(unsigned short pattern);
  /**
   * Gets the line pattern of the highlight.
   */
  unsigned short getLinePattern();
  /**
   * Sets the line width of the highlight. Default is @B 3 @b. Application is
   * responsible for forcing a redraw of the scene to see the effects of this change.
   */
  void setLineWidth(float width);
  /**
   * Gets the line width of the highlight.
   */
  float getLineWidth();

protected:
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  SoSeparator* getLocalRoot();
  void setLocalRoot( SoSeparator* );

 private:
  
  // Nodes which comprise the local highlight graph
  SoSeparator *localRoot;

 private:

  // Copy Constructor Forbidden
  SoBoxHighlightRenderAction( const SoBoxHighlightRenderAction& ) : SoHighlightRenderAction() {}

  void constructorCommon();

  static void notificationCB(void* userData, SoSensor* sensor );

  bool updateBBoxSceneGraph(SoNode *renderRoot);

  SoNodeSensor* m_notificationNodeSensor;

  BoxHighlightCameraChecker* m_cameraChecker;
};

inline SoSeparator*
SoBoxHighlightRenderAction::getLocalRoot()
{
  return localRoot;
}
#endif /* _SO_BOX_HIGHLIGHT_RENDER_ACTION_ */


