/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_PICK_ACTION_
#define  _SO_PICK_ACTION_

#include <Inventor/SbViewportRegion.h>
#include <Inventor/actions/SoSubAction.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoPickAction
//
//  Base class for picking actions.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Abstract base class for picking objects in a scene.
 * 
 * @ingroup actions
 * 
 * @DESCRIPTION
 *   This is an abstract base class for all picking actions. Currently, the only
 *   supported subclass is the SoRayPickAction.
 * 
 * @SEE_ALSO
 *    SoRayPickAction
 * 
 * 
 */
class INVENTOR_API SoPickAction : public SoAction {

  SO_ACTION_HEADER(SoPickAction);

 public:
  /**
   * Sets current viewport region to use for action. Even though the picking
   * operation may not involve a window per se, some nodes need this information to
   * determine their size and placement.
   */
  void                setViewportRegion(const SbViewportRegion &newRegion);

  /**
   * Returns current viewport region to use for action. 
   */
  const SbViewportRegion &getViewportRegion() const   { return vpRegion; }

 SoEXTENDER_Documented public:
  // Setting this flag to FALSE disables any pick culling that might
  // take place (as in SoSeparators). This can be used for nodes
  // (such as SoArray and SoMultipleCopy) that traverse their
  // children multiple times in different locations, thereby
  // avoiding computing bounding boxes each time. (This problem is
  // very severe when each bounding box traversal also traverses the
  // children N times.) The default setting is TRUE.
  void                enableCulling(SbBool flag)      { culling = flag; }
  SbBool              isCullingEnabled() const        { return culling; }

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  SbViewportRegion    vpRegion;       // Current viewport region

  // Constructor takes viewport region. See comments for the
  // setViewportRegion() method.
  SoPickAction(const SbViewportRegion &viewportRegion);

  // Destructor
  virtual ~SoPickAction();

  // Initiates action on graph
  virtual void        beginTraversal(SoNode *node);

 private:
  SbBool              culling;        // Pick culling enabled?

};

#endif /* _SO_PICK_ACTION_ */

