/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#if !defined(SI_ANTIALIASING_EVENTLISTENER_H)
#define SI_ANTIALIASING_EVENTLISTENER_H

#include <Inventor/SoSceneManager.h>

/** 
 * @VSGEXT Antialiasing change event listener interface.
 *
 * @ingroup Antialiasing
 *
 * @DESCRIPTION
 * This interface provides the list of change event methods that subclasses must define.
 */
class INVENTOR_API SiAntialiasingEventListener
{
public:
  SiAntialiasingEventListener();

  virtual ~SiAntialiasingEventListener();

  /**
   * This method is called when the antialiasing parameters are modified in the scene manager. 
   *
   * @note
   * The mode provided here is the actual mode. If the SoSceneManager::setAntialiasing method is called with AUTO, the mode provided here will
   * be the algorithm selected by the scenemanager. The AUTO mode will never be used here.
   *
   * @return a boolean to indicates if the listener was able to configure the graphic device for the specified mode.
   */
  virtual bool onAntialiasingSwitch(const SoSceneManager::AntialiasingMode& mode, const float& quality, const SoAntialiasingParameters* parameters) = 0;
};


#endif // SI_ANTIALIASING_EVENTLISTENER_H
