/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#if !defined(SI_ANTIALIASINGPARAMETERS_H)
#define SI_ANTIALIASINGPARAMETERS_H

#include <Inventor/sys/port.h>

/** 
 * @VSGEXT Antialiasing parameters interface base class
 *
 * @ingroup Antialiasing
 *
 * @DESCRIPTION
 * This interface is the common interface for all the parameters classes used for 
 * the different antialiasing algorithms.  These objects are used with the
 * setAntialiasing() method in SoSceneManager and some viewer classes (e.g. SoWinGLWidget).
 *
 * @SEE_ALSO
 *   SoAccumulationAntialiasingParameters,
 *   SoFullSceneAntialiasingParameters,
 *   SoFXAAParameters
 */
class INVENTOR_API SoAntialiasingParameters
{
public:
  /** Default destructor */
  virtual ~SoAntialiasingParameters();

  /** Copy to a new instance */
  virtual SoAntialiasingParameters* copy() const = 0;

protected:
  /** Default constructor */
  SoAntialiasingParameters();
};

#endif // SI_ANTIALIASINGPARAMETERS_H
