/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_BASE_CONTEXT_CACHE_H_
#define _SO_BASE_CONTEXT_CACHE_H_

#include <Inventor/SbBase.h>
#include <Inventor/misc/SoRefCounter.h>
#include <Inventor/devices/SoSharedGroupReferenceList.h>

class SbThreadMutex;
class SoDeviceContextSharedGroup;

/**
 * @VSGEXT Base context dependent cache management class.
 *
 * @ingroup Caches
 * 
 * @DESCRIPTION
 *
 *  A helper base class used to store context dependent cache objects.
 *
 */
SoEXTENDER class INVENTORBASE_API SoBaseContextCache : public SoRefCounter
{
 public:

  /**
   * Constructor.
   */
  SoBaseContextCache();

  /**
   * This function is called when a context has been requested 
   * to delete the context through the SoDeviceContext::dispose() method.
   * As some object might be still attached, it triggers all attached object
   * release() method to ask them to detach (and then get it refcount to zero).
   */
  virtual void release( SoDeviceContextSharedGroup* ) = 0;

   /**
    * Object is considered not context dependent as long as 
    * SoDeviceContext was not ref by this object. Once at least one device is ref then
    * it calls this function to enbale later check checks deleting this object.
    * see (SoDeviceContext::checkRefIssue call in destructor).
    */
   inline void setContextDependent(const bool flag=true)
   { m_isContextDependent=flag; }

   /**
    * return current context dependency state.
    * (by default all caches are context dependent).
    */
   inline bool isContextDependent() const
   { return m_isContextDependent;}

 protected:

   /** Destructors (used by unref ) */
   virtual ~SoBaseContextCache();

private:

  // Intrusive list element pattern to provide O(1) unref from SoDeviceContextSharedGroup
  // Only SoSharedGroupReferenceList is manipulating this member.
  SoSharedGroupReference m_sharedgroupRef;
  friend class SoSharedGroupReferenceList;

  /** current context dependencie */
  bool m_isContextDependent;
};

#endif //SO_CONTEXTED_OBJECT


