/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_GL_BUFFEROBJECT_CACHE_LIST_H_
#define _SO_GL_BUFFEROBJECT_CACHE_LIST_H_

#include <Inventor/devices/SoBaseContextObject.h>
#include <Inventor/caches/SoContextedObjectCache.h>
#include <Inventor/devices/SoGLBufferObject.h>
#include <Inventor/devices/SoGLContext.h>
#include <Inventor/STL/vector>

SoINTERNAL class SoGLBufferObjectCache : public SoBaseContextObject
{
public:
  SoGLBufferObjectCache(SoState *)
    : SoBaseContextObject(SoGLContext::getCurrent()->getSharedGroup())
    , bufferObject(0)
  {
  }

  // Constructor
  SoGLBufferObjectCache(SoGLContext *)
    :SoBaseContextObject(SoGLContext::getCurrent()->getSharedGroup())
    , bufferObject(0)
  {
  }

  void createBufferObject( SoGLBufferObject::Usage usage, size_t size )
  {
    if (!bufferObject)
    {
      bufferObject = new SoGLBufferObject( usage );
      bufferObject->ref();
      bufferObject->setSize( size );
    }
  }

  virtual ~SoGLBufferObjectCache()
  {
    SO_UNREF_RESET(bufferObject);
  }

  SoGLBufferObject* getBufferObject() { return bufferObject; }

private:

  SoGLBufferObject* bufferObject;
};

typedef SoContextedObjectCache<SoGLBufferObjectCache> SoGLBufferObjectCacheList;


#endif // _SO_GL_BUFFEROBJECT_CACHE_LIST_H_

