/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_GL_GRAPHIC_DEVICE_PEER_H_
#define _SO_GL_GRAPHIC_DEVICE_PEER_H_

#include <Inventor/components/SoGLGraphicDevice.h>
#include <Inventor/components/SoGraphicConfig.h>
#include <Inventor/components/SoGLGraphicConfigTemplate.h>

#include <Inventor/STL/algorithm>
#include <Inventor/STL/functional>
#include <Inventor/STL/set>
#include <Inventor/STL/vector>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

typedef std::vector<SoGraphicConfig *> SoGraphicConfigList;
typedef std::set<int, std::less<int> > SoSamplesList;

/**
 * @VSGEXT Defines an OpenGL graphics device.
 * 
 * @ingroup General
 * 
 * @DESCRIPTION
 * This class is an abstraction of the internal part of a graphics device 
 * for OpenGL. It could be based on:
 *   - either an MS-Windows handler device context (HDC),
 *   - or X-windows graphics display (Display *),
 *   - or any other graphics device depending on the system (MacOS, etc.)
 *
 * This class declares or implements all required methods used in the
 * SoGLGraphicDevice class. This class is not inherited from SoGLGraphicDevice
 * but it is viewed and used as a peer in the OpenGL graphics device class.
 * 
 * @SEE_ALSO
 *    SoGraphicConfigTemplate, SoGLGraphicConfigTemplate, 
 *    SoGraphicConfigCompare, SoGLGraphicConfigCompare, 
 *    SoGraphicConfig, SoGraphicDevice, SoGLGraphicDevice.
 * 
 */
SoINTERNAL class INVENTOR_API SoGLGraphicDevicePeer {

 public:

  /**
   * Destructor.
   */
  virtual ~SoGLGraphicDevicePeer();

  /**
   * Returns the list of all the graphics modes
   * supported by this OpenGL graphics device.
   */
  virtual SoGraphicConfigList &getGraphicConfigsList();

  /** 
   * Returns the list of all the available number of samples
   * supported by this OpenGL graphics device.
   */
  virtual SoSamplesList &getSamplesParseTab();

  /**
   * Returns the default template used by Open Inventor.
   */
  virtual SoGLGraphicConfigTemplate getDefaultGraphicConfigTemplate() = 0;

  /**
   * Returns a template according to the given graphics configuration.
   */
  virtual SoGLGraphicConfigTemplate getGraphicConfigTemplate(SoGLGraphicConfig *graphicConfig) = 0;

  /**
   * Returns the Display corresponding to this graphics device. 
   */
  virtual SbGlContextHelper::Display getDisplay() = 0;

  /**
   * Returns the type of device.
   */
  virtual SoGLGraphicDevice::DeviceType getType() = 0;


 protected:

  /**
   * Builds the whole OpenGL graphics configurations list.
   */
  virtual void buildGraphicConfigsList() = 0;

  /**
   * Deletes all the elements of the configurations list.
   */
  virtual void clearGraphicConfigsList() = 0;

  /**
   * The OpenGL graphics configurations list.
   */
  SoGraphicConfigList m_configs;

  /**
   * The OpenGL graphics samples list.
   */
  SoSamplesList m_samplesParseTab; // 255 multisample levels ...
};
#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _SO_GL_GRAPHIC_DEVICE_PEER_H_ */

