/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_GRAPHIC_CONFIG_COMPARE_H_
#define _SO_GRAPHIC_CONFIG_COMPARE_H_

#include <Inventor/components/SoGraphicConfigTemplate.h>
#include <Inventor/components/SoGraphicConfig.h>

/**
 * @VSGEXT Defines an graphics compare object used to compare two
 * SoGraphicConfig objects according to an SoGraphicConfigTemplate object.
 *
 * @ingroup General
 *
 * @DESCRIPTION
 * This class allows the comparison of two graphics configurations.
 * To sort the list of its supported graphics configurations, a graphics device
 * need a predicate object which type is SoGraphicConfigCompare class or
 * derived from.
 * It takes the  graphics template in parameter to define the right order.
 * This order should be absolute (non ambiguous).
 *
 * @SEE_ALSO
 *    SoGraphicConfigTemplate, SoGLGraphicConfigTemplate,
 *    SoGraphicConfigCompare, SoGLGraphicConfigCompare,
 *    SoGraphicConfig, SoGraphicDevice, SoGLGraphicDevice.
 *
 */
SoINTERNAL class INVENTOR_API SoGraphicConfigCompare {

 public:
  virtual ~SoGraphicConfigCompare() {}

  SoGraphicConfigCompare(const SoGraphicConfigTemplate *temp = NULL);

  virtual SbBool operator()(SoGraphicConfig* const&gc1,
                            SoGraphicConfig* const&gc2) const = 0;

  const SoGraphicConfigTemplate *m_predicateTemplate;
};

#endif /* _SO_GRAPHIC_CONFIG_COMPARE_H_ */

