/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_ANAGLYPH_STEREO
#define _SO_WIN_ANAGLYPH_STEREO

#include <Inventor/components/stereo/SoBaseStereo.h>

class SoStereoViewer;

/**
 * @VSGEXT Class for anaglyph stereo support.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   This type is similar to the raw stereo type (SoRawStereo). But it adds a color
 *   filter for each view rendered. The default is Red/Cyan.
 *   There are three kinds of filters (#ColorFilter). You can reverse the left and rights views,
 *   making three new kinds of filters (CYAN_RED, etc.). The Alpha channel is used in
 *   both views.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoBaseStereo,
 *    SoWinViewer
 *    SoXtViewer
 *
 * [OIVJAVA-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORGUI_API SoAnaglyphStereo : public SoBaseStereo
{
public:
  /**
   * Color Filter.
   * There is 3 types of filters. Note that you can reverse the view,
   * making 3 new types of filters (CYAN_RED,etc.). Note also that this
   * types are able to deal with two-colors glasses (rather than 3 colors) :
   * RED_CYAN is also adpated for red/green glasses, and so on.
   * Note that the Alpha channel is kept in both views.
   */
  enum ColorFilter
  {
    /** Default value */
    RED_CYAN,
    GREEN_MAGENTA,
    BLUE_YELLOW //, GRAYSCALE // not implemented
  };

  /**
   * Constructor.
   */
  SoAnaglyphStereo( SoStereoViewer *stereoVwr = NULL, SoGuiViewer* guiViewer = NULL )
  : SoBaseStereo( stereoVwr, guiViewer )
  , m_colorFilter( RED_CYAN )
  {
  }

  /**
   * Destructor.
   */
  ~SoAnaglyphStereo() {}

  /**
   * Always returns SoBaseStereo::ANAGLYPH_STEREO.
   */
  StereoViewType getStereoViewType() { return ANAGLYPH_STEREO; }

  /**
   * Sets the filter type.
   */
  void setColorFilter( ColorFilter filter ) { m_colorFilter = filter; }

  /**
   * Queries the filter type.
   */
  ColorFilter getColorFilter() { return m_colorFilter; }

SoINTERNAL public:
  void doLeftEyeSettings( SoGLRenderAction* action );
  void doRightEyeSettings( SoGLRenderAction* action );
  void doMonoscopicSettings( SoGLRenderAction* action );

private:
  ColorFilter m_colorFilter;
};

#endif // _SO_WIN_ANAGLYPH_STEREO
