/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_RAWSTEREO
#define _SO_WIN_RAWSTEREO

#include <Inventor/components/stereo/SoBaseStereo.h>

class SoStereoViewer;

/**
 * @VSGEXT Class for OpenGL stereo support.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   This class implements the OpenGL "quad buffered" stereo type. This requires a
 *   stereo accelerated graphics board.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoBaseStereo,
 *    SoWinViewer
 *    SoXtViewer
 *    SoQtViewer
 *
 * [OIVJAVA-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORGUI_API SoRawStereo : public SoBaseStereo
{
public:
  /**
   * Constructor.
   */
  SoRawStereo( SoStereoViewer* stereoVwr = NULL, SoGuiViewer* guiViewer = NULL );

  /**
   * Destructor.
   */
  ~SoRawStereo();

  /**
   * Always returns SoBaseStereo::RAW_STEREO.
   */
  virtual StereoViewType getStereoViewType();

  /**
   * Always returns TRUE.
   */
  virtual SbBool requireHardware();

SoINTERNAL public:
  /**
   * For internal use only.
   */
  virtual SbBool isMPStereoViewTypeSupported()
  {
    return TRUE;
  };

  void doLeftEyeSettings( SoGLRenderAction* action );
  void doRightEyeSettings( SoGLRenderAction* action );
  void doMonoscopicSettings( SoGLRenderAction* action );
};

#endif // _SO_WIN_RAWSTEREO


