/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Howard Look (MMM yyyy)
** Modified by : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_DETAIL_
#define _SO_DETAIL_

#include <Inventor/SbBasic.h>
#include <Inventor/SoOutput.h>
#include <Inventor/SoTypedObject.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoDetail
//
//  Base class for all detail classes. A detail represents extra
//  information about a point on a surface, such as an intersection
//  returned from picking along a ray (SoPickedPoint) or as a vertex
//  of a generated primitive (SoPrimitiveVertex).
//
//  The base class does not contain any useful information. It is here
//  only as an abstract class. Subclasses can add useful detail
//  information, such as a part index or nearest vertex.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Base class for describing detail information about a shape node.
 * 
 * @ingroup details
 * 
 * @DESCRIPTION
 *   SoDetail is the abstract base class for all detail classes. A detail contains
 *   shape-specific information about a particular shape during picking and primitive
 *   generation. Subclasses store information based on the particular type of shape.
 * 
 * @SEE_ALSO
 *    SoConeDetail,
 *    SoCubeDetail,
 *    SoCylinderDetail,
 *    SoDetailList,
 *    SoFaceDetail,
 *    SoLineDetail,
 *    SoNodeKitDetail,
 *    SoPickedPoint,
 *    SoPointDetail,
 *    SoPrimitiveVertex,
 *    SoTextDetail
 * 
 * [OIV-WRAPPER-CLASS ALL_DERIVABLE]
 */
class INVENTOR_API SoDetail: public SoTypedObject {
 public:
  // Destructor
#ifndef HIDDEN_FROM_DOC
  virtual ~SoDetail();
#endif // HIDDEN_FROM_DOC

  /**
   * Returns type identifier for this class.
   */
  static SoType       getClassTypeId();

  /**
   * Returns an instance that is a copy of this instance. The caller is responsible
   * for deleting the copy when it is no longer needed.
   */
  virtual SoDetail *  copy() const = 0;

  /*
   *  Writes instance to SoOutput. Must be defined by all sub-class
   */
  //virtual void writeInstance(SoOutput *out);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

  // Initialize ALL Inventor detail classes
  static void         initClasses();
  static void         exitClasses();

 protected:
  // Constructor is protected since this is an abstract class
  SoDetail();

 private:
  // Type identifier
  static SoType classTypeId;
};

#endif /* _SO_DETAIL_ */


