/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Thaddeus Beier (MMM yyyy)
** Modified by : Dave Immel (MMM yyyy)
** Modified by : Howard Look (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_LINE_DETAIL_
#define _SO_LINE_DETAIL_

#include <Inventor/details/SoPointDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoLineDetail
//
//  Detail information about vertex-based shapes made of line
//  segments. It adds indices of various items that vary among lines,
//  segments, and vertices.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about vertex-based shapes made of line segments.
 * 
 * @ingroup details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a line segment in a
 *   vertex-based shape made of line segments. The information includes the points at
 *   the ends of the segment, and the index of the segment within the shape.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex,
 *    SoVertexShape
 * 
 * 
 */
class INVENTOR_API SoLineDetail : public SoDetail {

  SO_DETAIL_HEADER(SoLineDetail);

 public:
  /**
   * Constructor.
   */
  SoLineDetail();
  /**
   * Destructor.
   */
  virtual ~SoLineDetail();

  /**
   * Returns information about the first of two points forming the end vertices of the
   * line segment, represented as an SoPointDetail.
   */
  const SoPointDetail *       getPoint0() const       { return &point[0]; }
  /**
   * Returns information about the second of two points forming the end vertices of the
   * line segment, represented as an SoPointDetail.
   */
  const SoPointDetail *       getPoint1() const       { return &point[1]; }

    /**
   * Returns information about the point forming the i'th end of the line,
   * represented as an SoPointDetail.
   */
  const SoPointDetail *           getPoint(int32_t i) const ;

  /**
   * Returns the index of the line the segment is part of within a shape, such as the
   * third line within an SoLineSet.
   */
  int32_t                     getLineIndex() const    { return lineIndex; }

  /**
   * Returns the index of the part containing the line segment within the shape.
   * Usually, the part index is the same as the line segment index, such as the fifth
   * segment overall within an SoLineSet.
   */
  int32_t                     getPartIndex() const    { return partIndex; }

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

 SoEXTENDER public:
  // Copies a point detail from the given detail
  void                        setPoint0(const SoPointDetail *pd);
  void                        setPoint1(const SoPointDetail *pd);
  void                        setPoint(int32_t index, const SoPointDetail *pd);

  // Return a pointer to the point details.
  SoPointDetail *             getPoints()             { return &point[0]; }

  // Sets the line index and part index
  void                        setLineIndex(int32_t i) { lineIndex = i; }
  void                        setPartIndex(int32_t i) { partIndex = i; }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void    setLineIndex(long i)                                // System long
    { setLineIndex ((int32_t) i); }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void    setPartIndex(long i)                                // System long
    { setPartIndex ((int32_t) i); }

 SoINTERNAL public:

  SoLineDetail( const SoLineDetail& lineDetail );
  SoLineDetail& operator=( const SoLineDetail& lineDetail );
  void copy( const SoLineDetail& lineDetail );
  SoPointDetail* getPoint_(int32_t i) const;

  static void                 initClass();
  static void                 exitClass();

 private:
  SoPointDetail               point[2];
  int32_t                     lineIndex, partIndex;

};

#endif /* _SO_LINE_DETAIL_ */

