/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_NODE_KIT_DETAIL_
#define _SO_NODE_KIT_DETAIL_

#include <Inventor/details/SoSubDetail.h>

class SoNode;
class SoBaseKit;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoNodeKitDetail
//
//  Base class for all detail classes.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Stores detail information about a nodekit.
* 
* @ingroup details
* 
* @DESCRIPTION
*   This class contains detail information about a nodekit. This consists of a
*   reference to the nodekit, a reference to the child part within the nodekit, and the
*   name of the child part.
*   
*   During a pick action, each nodekit along the picked path creates its own
*   SoNodeKitDetail. Together, the full set of details gives you a complete picture of
*   the pickpath.
*   
*   Since nodekits have hidden children (see the reference page for SoBaseKit), a
*   regular SoPath ends at the topmost nodekit in the path. If you cast the pickpath
*   from an SoPath to an SoNodeKitPath, you can then retrieve all
*   nodekits along the path and examine their corresponding details.
* 
* @SEE_ALSO
*    SoBaseKit,
*    SoNodeKitPath,
*    SoDetail,
*    SoPickedPoint
* 
* 
*/
class INVENTOR_API SoNodeKitDetail : public SoDetail {
    
  SO_DETAIL_HEADER(SoNodeKitDetail);

 public:
  /**
   * Constructor.
   */
  SoNodeKitDetail();
  /**
   * Destructor.
   */
  virtual ~SoNodeKitDetail();

 /**
  * Returns a reference to the nodekit that created this detail.
  */
  SoBaseKit *getNodeKit() const { return myNodeKit; }

 /**
  * Returns a reference to the part selected within the nodekit that created this
  * detail.
  */
  SoNode *getPart() const { return myPart; }

  /**
   * Returns the name of the part selected within the nodekit that created this
   * detail. (See SoRayPickAction in the ACTIONS section of the SoBaseKit reference
   * page for more information).
   */
  const SbName &getPartName() const { return myPartName; }

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

 SoEXTENDER public:

  void setNodeKit( SoBaseKit *theNodeKit );
  void setPart( SoNode *thePart );
  void setPartName( const SbName &theName )      { myPartName = theName; }

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  SoBaseKit       *myNodeKit;
  SoNode          *myPart;
  SbName          myPartName;

};

#endif /* _SO_NODE_KIT_DETAIL_ */


