/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Thaddeus Beier (MMM yyyy)
** Modified by : Dave Immel (MMM yyyy)
** Modified by : Howard Look (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_POINT_DETAIL_
#define _SO_POINT_DETAIL_

#include <Inventor/details/SoSubDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoPointDetail
//
//  Detail information about vertex-based shapes made of points. It
//  stores indices of various items that vary from point to point.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about vertex-based shapes made of points.
 * 
 * @ingroup details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a point in a vertex-based shape
 *   made of points. It is used for returning information about an intersection with
 *   or primitives generated by a set of points. It is also used by SoFaceDetail and
 *   SoLineDetail to return information about the vertices of faces and line
 *   segments.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex,
 *    SoVertexShape,
 *    SoFaceDetail,
 *    SoLineDetail
 * 
 * 
 */
class INVENTOR_API SoPointDetail : public SoDetail {

  SO_DETAIL_HEADER(SoPointDetail);

 public:
  /**
   * Constructor.
   */
  SoPointDetail();
  /**
   * Destructor.
   */
  virtual ~SoPointDetail();

  /**
   * Returns the index of the point within the relevant coordinate node.
   */
  int32_t     getCoordinateIndex() const      { return coordIndex; }

  /**
   * Returns the index of the material for the point within the relevant material
   * node.
   */
  int32_t     getMaterialIndex() const        { return materialIndex; }
  /**
   * Returns the index of the surface normal at the point within the relevant normal
   * node. Note that if normals have been generated for a shape, the index may not be
   * into an existing normal node.
   */
  int32_t     getNormalIndex() const          { return normalIndex; }
  /**
   * Returns the index of the texture coordinates for the point within the relevant
   * normal node. Note that if texture coordinates have been generated for a shape,
   * the index may not be into an existing texture coordinate node.
   */
  int32_t     getTextureCoordIndex() const    { return texCoordIndex; }

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

 SoEXTENDER public:
  // Each of these sets one of the indices in the detail
  void        setCoordinateIndex(int32_t i)   { coordIndex    = i; }
  void        setMaterialIndex(int32_t i)     { materialIndex = i; }
  void        setNormalIndex(int32_t i)               { normalIndex   = i; }
  void        setTextureCoordIndex(int32_t i) { texCoordIndex = i; }
  const SoPointDetail* getPoint( int32_t i ) const;

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void      setCoordinateIndex(long i)                       // System long
    { setCoordinateIndex ((int32_t) i); }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void      setMaterialIndex(long i)                         // System long
    { setMaterialIndex ((int32_t) i); }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void      setNormalIndex(long i)                           // System long
    { setNormalIndex ((int32_t) i); }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void      setTextureCoordIndex(long i)                     // System long
    { setTextureCoordIndex ((int32_t) i); }

 SoINTERNAL public:
  SoPointDetail( const SoPointDetail& pointDetail );
  SoPointDetail& operator=( const SoPointDetail& pointDetail );
  void copy ( const SoPointDetail& pointDetail );
  SoPointDetail* getPoint_( int32_t i ) const;

  static void initClass();
  static void exitClass();

 private:
  int32_t     coordIndex, materialIndex, normalIndex, texCoordIndex;

};

#endif /* _SO_POINT_DETAIL_ */

