/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SUB_DETAIL_
#define  _SO_SUB_DETAIL_

#include <Inventor/details/SoDetail.h>
#include <Inventor/errors/SoDebugError.h>

/////////////////////////////////////////////////////////////////////////////
//
// Macros to be called within the class definition header for a detail
// subclass:
//

////////////////////////////////////////////
//
// This defines type-identifier variables and methods that all
// subclasses must support. 
//

#define SO_DETAIL_HEADER(className)                                           \
  public:                                                                     \
    /** Returns the type identifier for this specific instance. */            \
    virtual SoType              getTypeId() const;                            \
    /** Returns the type identifier for this class.  */                       \
    static SoType               getClassTypeId() ;                            \
  private:                                                                    \
    static SoType              classTypeId

/////////////////////////////////////////////////////////////////////////////
//
// Macros to be called within the source file for a detail subclass:
//

////////////////////////////////////////////
//
// This declares the static variables defined in SO_DETAIL_HEADER.
//

#define SO__DETAIL_ID_VARS(className)                                         \
  SoType className::classTypeId;

////////////////////////////////////////////
//
// This implements the methods defined in SO_DETAIL_HEADER.
//

#define SO__DETAIL_ID_METHODS(className)                                      \
                                                                              \
SoType                                                                        \
className::getClassTypeId()                                                   \
{                                                                             \
    return classTypeId;                                                       \
}                                                                             \
SoType                                                                        \
className::getTypeId() const                                                  \
{                                                                             \
    return classTypeId;                                                       \
}

////////////////////////////////////////////
//
// This contains the definitions necessary at file scope
//
#define SO_DETAIL_SOURCE(className)                                           \
    SO__DETAIL_ID_VARS(className);                                            \
    SO__DETAIL_ID_METHODS(className)


#if defined(_DEBUG)
#define SO_DETAIL_INIT_CLASS_CHECK_PARENT(className, parentClass)                   \
  if (parentClass::getClassTypeId().isBad()) {                                        \
    SoDebugError::post( SO__QUOTE(className)"::initClass",                            \
      SO__QUOTE(className)" initialized before parent class " \
      SO__QUOTE(parentClass)"\n");                                                    \
    parentClass::initClass();                                                         \
  }
#else
#define SO_DETAIL_INIT_CLASS_CHECK_PARENT(className, parentClass)                   \
  if (parentClass::getClassTypeId().isBad())                                          \
    parentClass::initClass()
#endif

////////////////////////////////////////////
//
// This initializes the type identifer variables defined in
// SO_DETAIL_HEADER. This macro should be called from within
// initClass().
//
#define SO_DETAIL_INIT_CLASS_INTERNAL(className, parentClass) \
  SO_DETAIL_INIT_CLASS_CHECK_PARENT(className, parentClass); \
  classTypeId = SoType::createType(parentClass::getClassTypeId(), SO__QUOTE(className), NULL);

#define SO_DETAIL_INIT_CLASS(className, parentClass) \
  SO_DETAIL_INIT_CLASS_INTERNAL(className, parentClass)

#if defined(_DEBUG)
#define SO_DETAIL_EXIT_CLASS(className) \
  if (! SoType::removeType(classTypeId.getName())) { \
    SoDebugError::post(SO__QUOTE(className)"::exitClass", \
                       "Unable to remove type (%s) for this class. Check exitClass() " \
                       "method is implemented and is called only once.\n", \
                       classTypeId.getName().getString() ); \
  } \
  else \
    classTypeId = SoType::badType()
#else
#define SO_DETAIL_EXIT_CLASS(className) \
  SoType::removeType(classTypeId.getName()); \
  classTypeId = SoType::badType()
#endif

#endif /* _SO_SUB_DETAIL_ */


