/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Thaddeus Beier (MMM yyyy)
** Modified by : Dave Immel (MMM yyyy)
** Modified by : Howard Look (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_TEXT_DETAIL_
#define _SO_TEXT_DETAIL_

#include <Inventor/SbBox.h>
#include <Inventor/details/SoSubDetail.h>
#include <Inventor/nodes/SoText3.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoTextDetail
//
//  Detail about a shape representing text.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Stores detail information about a text node.
 * 
 * @ingroup details
 * 
 * @DESCRIPTION
 *   This class contains detail information about a point on a text shape (SoText2 or
 *   SoText3). It contains the part of the text, string, and character that were hit
 *   or generated.
 * 
 * @SEE_ALSO
 *    SoText2,
 *    SoText3,
 *    SoDetail,
 *    SoPickedPoint,
 *    SoPrimitiveVertex
 * 
 * 
 */
class INVENTOR_API SoTextDetail : public SoDetail {

  SO_DETAIL_HEADER(SoTextDetail);

 public:
  /**
   * Constructor.
   */
  SoTextDetail();
  /**
   * Destructor.
   */
  virtual ~SoTextDetail();

  /**
   * Returns the index of the relevant string within a multiple-value @B string @b
   * field of a text node.
   */
  int32_t             getStringIndex() const          { return stringIndex; }

  /**
   * Returns the index of the relevant character within the string. For example, if
   * the character of detail was the "u" within "Splurmph", the character index would
   * be 3.
   */
  int32_t             getCharacterIndex() const       { return charIndex; }

  /**
   * For SoText3, this returns which part was picked or generated.
   */
  SoText3::Part       getPart() const         { return part; }

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

 SoEXTENDER public:
  // For Text3, this sets which part is picked:
  void                setPart(SoText3::Part p)        { part = p; }

  // These set the string and character indices:
  void                setStringIndex(int32_t i)               { stringIndex = i; }
  void                setCharacterIndex(int32_t i)    { charIndex = i; }

  /** 
  * [OIV-WRAPPER NO_WRAP]
  */
  void    setStringIndex(long i)                              // System long
    { setStringIndex((int32_t) i); }

  /**
  * [OIV-WRAPPER NO_WRAP]
  */
  void    setCharacterIndex(long i)                           // System long
    { setCharacterIndex((int32_t) i); }

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 private:
  int32_t             stringIndex, charIndex;
  SoText3::Part       part;

};

#endif /* _SO_TEXT_DETAIL_ */

