/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#if !defined SODEVICECONTEXT_H
#define SODEVICECONTEXT_H

#include <Inventor/SbBase.h>
#include <Inventor/misc/SoRefCounter.h>
#include <Inventor/STL/set>
#include <Inventor/STL/list>
#include <Inventor/threads/SbThread.h>
#include <Inventor/threads/SbThreadMutex.h>
#include <Inventor/threads/SbThreadSpinlock.h>
#include <Inventor/devices/SoDeviceContextSharedGroup.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class SbThreadMutex;
class SoBaseContextCache;

/**
* @VSGEXT Abstract base class for device context managment
*
* @ingroup Devices
*
* @DESCRIPTION
*
* This class provides generic functions to manage or get data about specific device contexts.
*
* \if_cpp
* @B Reference counting:@b 
* - If a device context is bound when a corresponding device buffer object is
*   created, the buffer object will ref() the context (and unref() it when the
*   buffer object is destroyed).
* \endif
* 
*
*/
class INVENTORBASE_API SoDeviceContext : public SoRefCounter
{
public:

  /**
   * Default constructor.
   */
  SoDeviceContext();

  /**
   * Bind this context to the current thread.
   */
  virtual void bind() = 0;

  /**
   * Unbind this context from the current thread.
   */
  virtual void unbind() = 0;

  /**
   * Returns true if two contexts are compatible. @BR
   *
   * Compatible means that using a buffer from one of these contexts inside
   * the other will not require copying the data.
   */
  virtual bool isCompatible( SoDeviceContext* ) const = 0;

  /**
   * Returns true if the context is valid and currently active.
   */
  virtual bool isCurrent() const =0;

  /** Sets the sharable property. */
  void setSharable( bool sharable );

  /** Returns the sharable status of this context. By default, a context is sharable. */
  bool isSharable() const;

  /** Share this context. */
  virtual bool setSharedWith( SoDeviceContext* sourceCtx );

  /** Returns the current sharing state with passed context. */
  virtual bool isSharedWith( const SoDeviceContext* context ) const;

  /** Returns an id common to all compatible/shared contexts. */
  virtual int getSharedId() const;

  /** Returns the current shared group. */
  SoDeviceContextSharedGroup* getSharedGroup() const;

  /** Explicitly change the sharedGroup. */
  bool setSharedGroup(SoDeviceContextSharedGroup* sharedGroup);
  
  /**
   * Returns true if this context is valid.
   *
   * @return true if the context is valid.
   */
  virtual bool isValid() const;

SoINTERNAL public:

  virtual SbString getInfos();

protected:
  /**
   * Destructor (use ref/unref to really delete).
   */
  virtual ~SoDeviceContext();

  /** Lock the context. */
  void lockContext();

  /** Unlock the context. */
  void unlockContext();
  
private:

  /** Context thread mutex. */
  SbThreadMutex m_mutex;

  /** Context shared group. */
  SoRef<SoDeviceContextSharedGroup> m_sharedGroup;

  /** Sharable property. */
  bool m_isSharable;

  friend class SoGLContext_qtcontext_OIV_875_Stub;
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif //#SODEVICECONTEXT_H

