/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/SbString.h>
#include <Inventor/SbVec.h>
#include <Inventor/SbPImpl.h>

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoGLScreenDevice);

class SoGLDevice;

/**
* @VSGEXT GL Screen device class
* @ingroup GLDevice
*
* @DESCRIPTION
*
* This class is used to query screen properties. You can query, for
* example, the resolution in pixels of the device.
* The list of screens connected to a GPU can be retrieved from the function
* SoGLDevice#getScreenDevice.
* The main screen connected to a GPU can be retrieved from the function
* SoGLDevice#getMainScreenDevice.
*
* @SEE_ALSO
*   SoGLDevice
*
*/
class INVENTORGL_API SoGLScreenDevice
{
  friend class SoGLDevice;

  SO_PIMPL_BASE_PUBLIC_HEADER(SoGLScreenDevice);

public:

  /**
   * Returns the device's physical size (in millimeters).
   */
  SbVec2f getPhysicalSize() const;

  /**
   * Returns the device's resolution in pixels.
   */
  SbVec2i32 getResolution() const;

  /**
   * Returns the number of bits per pixel of the device.
   */
  unsigned int getColorDepth() const;

  /**
   * Returns an user presentable string representing the device.
   */
  SbString getName() const;

  /**
   * Returns the SoGLDevice object on which the device is connected.
   */
  SoGLDevice* getGLDevice() const;

  /**
   * Prints information about this device.
   */
  friend std::ostream& operator << ( std::ostream& os, const SoGLScreenDevice& dev )
  {
    return os << "[Name]: " << dev.getName().toLatin1() << "\n" << \
                 "[Physical size]: " << dev.getPhysicalSize()[0] << "mm * " << dev.getPhysicalSize()[1] << "mm" << "\n" << \
                 "[Resolution]: " << dev.getResolution()[0] << "px * " << dev.getResolution()[1] << "px" << "\n" << \
                 "[Color depth]: " << dev.getColorDepth();
  }

protected:

  /**
   * Protected constructor.
   */
  SoGLScreenDevice();

  /**
   * Protected destructor.
   */
  virtual ~SoGLScreenDevice();
};
