/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
#ifndef SO_INTEROP_BUFFER_OBJECT_H
#define SO_INTEROP_BUFFER_OBJECT_H

#include <Inventor/devices/SoBufferObject.h>

/**
 * @VSGEXT Abstract base class for interoperability buffer object management
 *
 * @ingroup Devices
 *
 * @DESCRIPTION
 *
 * This class provides generic functions to manage buffer objects for interoperability.
 *
 * @SEE_ALSO
 *   SoGLBufferObject,
 *   SoGLDevice
 */
class INVENTORBASE_API SoInteropBufferObject: public SoBufferObject
{
  SO_TYPED_CLASS_ABSTRACT_HEADER()
  SO_PIMPL_ABSTRACT_PUBLIC_HEADER(SoInteropBufferObject, SoBufferObject)

public:

  /**
   * Default constructor
   */
  SoInteropBufferObject();

  /**
   * @copydoc SoBufferObject::createInstance
   */
  virtual SoBufferObject* createInstance() const = 0;

  /**
   * @copydoc SoBufferObject::clearInstance
   */
  virtual void clearInstance() = 0;

};

#endif // SO_INTEROP_BUFFER_OBJECT_H


