/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
** Modified by : Howard Look (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TAB_BOX_DRAGGER_
#define  _SO_TAB_BOX_DRAGGER_

#include <Inventor/SbLinear.h>
#include <Inventor/draggers/SoDragger.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoSFColor.h>
#include <Inventor/sensors/SoSensor.h>
#include <Inventor/misc/SoRef.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoShapeHints.h>

class SoFieldSensor;
class SoSwitch;
class SoDrawStyle;

/**
 * Cubic object you can translate and scale by dragging with the mouse.
 * 
 * @ingroup draggers
 * 
 * @DESCRIPTION
 *   SoTabBoxDragger is a composite dragger shaped like a box. Inside it are six
 *   SoTabPlaneDraggers which the dragger positions and orients to form a cube. The
 *   operations available in an SoTabPlaneDragger (translation, 1D scaling and 2D
 *   scaling) are available on each face of the cube. Since they each move in their own
 *   local space, the dragger may be easily translated or scaled in any direction.
 *
 *   Clicking and dragging a @B corner tab @b does a 2D scaling in the plane of the tab by 
 *   scaling, centered on the opposite corner of that face of the dragger, meaning that the opposite corner is the only corner that won't move. @BR
 *   Note: Holding the @B SHIFT @b key while dragging a corner tab forces uniform
 *   scaling.
 *
 *   Clicking and dragging an @B edge tab @b does 1D scaling about the opposite edge
 *   of that face.
 *
 *   Clicking and dragging a @B face @b does translation within the plane of the face.
 *   Although the face of the dragger is invisible (using the default dragger geometry)
 *   it is pickable. @BR
 *   Note: Holding the @B SHIFT @b key while dragging a face forces axis constrained
 *   dragging. The drag axis is determined by the initial drag direction.
 *   
 *   As a composite dragger, this class makes sure that when one plane is dragged, the
 *   entire box moves together.
 *   
 *   Each SoTabPlaneDragger tries to keep the small tabs a constant size in screen 
 *   space. Every time a drag begins or ends, the size is automatically recalculated
 *   based on the viewing and modeling matrix. When the #resizeHandles field is set
 *   to TRUE (the default), the tab size is also recalculated during the
 *   render traversal if the view matrix has changed (usually because the camera
 *   position and/or orientation changed).  The application can also force the tab
 *   size to be recomputed by calling the #adjustScaleTabSize() method.
 *
 *   If the dragger becomes too small in one dimension to contain all three tabs
 *   (two corner tabs plus the edge tab), the middle (edge) tab will not be drawn.
 *   If the dragger becomes very small (or flat) in one dimension, it may not be
 *   possible for the user to resize using the tabs.  One solution for this is to
 *   provide a "reset dragger" button in the application.
 *   
 *   When dragging the translator part, press the \<Shift\> key and you can constrain
 *   motion to either the local @B x axis @b or the @B y axis @b. The direction is
 *   determined by your initial mouse gesture after pressing the key. Releasing the
 *   key removes the constraint.
 *   
 *   As each sub-dragger is moved, the SoTabBoxDragger updates its #scaleFactor
 *   and #translation fields. As with all draggers, if you change a field the
 *   dragger will move to match the new settings.
 *   
 *   @B Remember: @b This is @B not @b an SoTransform!. If you want to move other
 *   objects with this dragger, you can:
 *   
 *     - Use an SoTabBoxManip, which is subclassed from SoTransform. It creates one of
 *       these draggers and uses it as the interface to change its fields.
 *
 *     - Use an SoROIManip, which is subclassed from SoROI, if your goal is to
 *       do volume rendering and interact with a region-of-interest.  This is commonly
 *       used for medical volume data and seismic volume data.
 *   
 *     - Use field-to-field connections to connect the fields of this dragger to those
 *       of any SoTransformation node.
 *
 *     - Use the standard dragger callbacks, see for example SoDragger::addValueChangedCallback.
 *   
 *   You can change the parts in any instance of this dragger using setPart().
 *   The default part geometries are defined as resources for this SoTabBoxDragger
 *   class. They are detailed below in the Dragger Resources section of the online
 *   reference page for this class. You can make your program use different default
 *   resources for the parts by copying the file
 *   @B $OIVHOME/data/draggerDefaults/tabBoxDragger.iv @b into your own directory,
 *   editing the file, and then setting the environment variable
 *   @B SO_DRAGGER_DIR @b to be a path to that directory.
 *
 *   This dragger has both a default and a WYSIWYG version:
 *      \par
 *      @TABLE_1B
 *         @TR Default Dragger @TD WYSIWYG Dragger
 *         @TR @IMAGE SoTabBoxDragger.png
 *         @TD @IMAGE SoTabBoxDraggerWYSIWYG.png
 *      @TABLE_END
 *
 *   See SoDragger for more information about using and customizing draggers,
 *   including code examples, using draggers in an immersive VR environment and using WYSIWYG draggers.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TabBoxDragger {
 *    @TABLE_FILE_FORMAT
 *       @TR boundingBoxCaching           @TD AUTO
 *       @TR renderCulling                @TD AUTO
 *       @TR pickCulling                  @TD AUTO
 *       @TR isActive                     @TD FALSE
 *       @TR resizeHandles                @TD TRUE
 *       @TR translation                  @TD 0 0 0
 *       @TR scaleFactor                  @TD 1 1 1
 *       @TR tabPixelSize                 @TD 8
 *       @TR callbackList                 @TD NULL
 *       @TR surroundScale                @TD NULL
 *       @TR privateStyle                 @TD FALSE
 *       @TR highlightColor               @TD 1.0 1.0 0.0
 *       @TR enableHighlight              @TD TRUE
 *       @TR tabPlane1                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR tabPlane2                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR tabPlane3                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR tabPlane4                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR tabPlane5                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR tabPlane6                    @TD TabPlaneDragger {
 *       @TR      }                       @TD 
 *       @TR boxGeom                      @TD \<tabBoxBoxGeom resource\>
 *       @TR tabPlane1.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane2.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane3.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane4.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane5.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane6.translator         @TD \<tabBoxTranslator resource\>
 *       @TR tabPlane1.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane2.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane3.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane4.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane5.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane6.scaleTabMaterial   @TD \<tabBoxScaleTabMaterial resource\>
 *       @TR tabPlane1.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *       @TR tabPlane2.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *       @TR tabPlane3.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *       @TR tabPlane4.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *       @TR tabPlane5.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *       @TR tabPlane6.scaleTabHints      @TD \<tabBoxScaleTabHints resource\>
 *    @TABLE_END
 *    }
 * 
 * 
 * @DRAGGER_RESOURCES
 *    @TABLE_DRAGGER_RESOURCES
 *       @TR Resource:      @TD @B tabBoxTranslator @b
 *       @TR Parts:         @TD tabPlane1.translator@BR
 *                               tabPlane2.translator@BR
 *                               tabPlane3.translator@BR
 *                               tabPlane4.translator@BR
 *                               tabPlane5.translator@BR
 *                               tabPlane6.translator 
 *       @TR Appearance:    @TD Outline of a Square. The region within is pickable
 *       @TR Description:   @TD Begins translation within the plane. The tabBox places and orients each tabPlane
 *                           so that these squares form a box.
 * 
 *       @TR Resource:      @TD @B tabBoxScaleTabMaterial @b
 *       @TR Parts:         @TD tabPlane1.scaleTabMaterial@BR
 *                               tabPlane2.scaleTabMaterial@BR
 *                               tabPlane3.scaleTabMaterial@BR
 *                               tabPlane4.scaleTabMaterial@BR
 *                               tabPlane5.scaleTabMaterial@BR
 *                               tabPlane6.scaleTabMaterial 
 *       @TR Appearance:    @TD Green - half diffuse, half emissive.
 *       @TR Description:   @TD Used as material for scaling tabs.
 * 
 *       @TR Resource:      @TD @B tabBoxScaleTabHints @b
 *       @TR Parts:         @TD tabPlane1.scaleTabHints@BR
 *                               tabPlane2.scaleTabHints@BR
 *                               tabPlane3.scaleTabHints@BR
 *                               tabPlane4.scaleTabHints@BR
 *                               tabPlane5.scaleTabHints@BR
 *                               tabPlane6.scaleTabHints 
 *       @TR Appearance:    @TD shapeHints node:COUNTERCLOCKWISE/SOLID/CONVEX
 *       @TR Description:   @TD Property for the tab nodes.
 * 
 *       @TR Resource:      @TD @B tabBoxBoxGeom @b
 *       @TR Part:          @TD boxGeom
 *       @TR Appearance:    @TD Unpickable gray outline of a box.
 *       @TR Description:   @TD Just feedback.
 * 
 *    @TABLE_END
 * 
 * @CATALOG_PARTS
 *    All Parts
 *    @TABLE_CATALOG_PART
 *       @TR   callbackList   @TD   NodeKitListPart  @TD    --      @TD   yes     
 *       @TR   surroundScale  @TD   SurroundScale    @TD    --      @TD   yes     
 *       @TR   tabPlane1      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   tabPlane2      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   tabPlane3      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   tabPlane4      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   tabPlane5      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   tabPlane6      @TD   TabPlaneDragger  @TD    --      @TD   yes     
 *       @TR   boxGeom        @TD   Separator        @TD    --      @TD   yes     
 *    @TABLE_END
 * 
 *    Extra Information for List Parts from Above Table
 *    @TABLE_LIST_PART
 *       @TR   callbackList   @TD   Separator        @TD   Callback, EventCallback
 *    @TABLE_END
 * 
 * @SEE_ALSO
 *    SoTabBoxManip,
 *    SoROIManip,
 *    SoInteractionKit,
 *    SoDragger,
 *    SoCenterballDragger,
 *    SoDirectionalLightDragger,
 *    SoDragPointDragger,
 *    SoHandleBoxDragger,
 *    SoJackDragger,
 *    SoPointLightDragger,
 *    SoRotateCylindricalDragger,
 *    SoRotateDiscDragger,
 *    SoRotateSphericalDragger,
 *    SoScale1Dragger,
 *    SoScale2Dragger,
 *    SoScale2UniformDragger,
 *    SoScaleUniformDragger,
 *    SoSpotLightDragger,
 *    SoTabPlaneDragger,
 *    SoTrackballDragger,
 *    SoTransformBoxDragger,
 *    SoTransformerDragger,
 *    SoTranslate1Dragger,
 *    SoTranslate2Dragger,
 *    SceneOrbiter,
 *    SceneExaminer
 */
class INVENTOR_API SoTabBoxDragger : public SoDragger
{
  SO_KIT_HEADER(SoTabBoxDragger);

  // For making the dragger surround what lies above it.
  SO_KIT_CATALOG_ENTRY_HEADER(surroundScale);

  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane1Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane1Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane1);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane2Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane2Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane2);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane3Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane3Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane3);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane4Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane4Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane4);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane5Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane5Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane5);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane6Sep);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane6Xf);
  SO_KIT_CATALOG_ENTRY_HEADER(tabPlane6);

  SO_KIT_CATALOG_ENTRY_HEADER(boxGeom);

 public:
  /**
   * Constructor.
   */
  SoTabBoxDragger();

  /**
   * Position of the dragger. Default is 0,0,0.
   */
  SoSFVec3f translation;

  /**
   * Scale of the dragger. Default is 1,1,1.
   */
  SoSFVec3f scaleFactor;

  /**
  * If set to TRUE, handles will be resized at each camera motion. Default is TRUE.
  * 
  * @FIELD_SINCE_OIV 7.0
  */
  SoSFBool resizeHandles;

  /** 
  * Specifies the size of the green tabs in pixels.  Default is 8
  * 
  * @FIELD_SINCE_OIV 9.2
  */
  SoSFInt32 tabPixelSize;

  /**
  * Controls whether this instance of SoTabBoxDragger shares or does not
  * share parts, e.g. tabBoxTranslator, tabBoxScaleTabMaterial and tabBoxScaleTabHints
  * with all other existing instances of SoTabBoxDragger.
  * Default is false, meaning parts are shared. Set this field to true if your
  * application needs to change these parts without affecting
  * other draggers in the scene graph.
  * (Indeed, the default was true prior to version 9.6.1)
  *
  * @FIELD_SINCE_OIV 9.6.1
  */
  SoSFBool privateStyle;

  /**
   * Specifies the highlight color. See also #enableHighlight.
   * The default color is yellow (1,1,0).
   */
  SoSFColor highlightColor;

  /**
   * Enables highlighting for tabs and faces.
   * When this field is true, during a mousemove event, once the cursor moves over a tab or a face of the dragger,
   * this element is highlighted according to the #highlightColor. This element is no longer highlighted once the cursor is no longer over it.
   * Default is true.
   */
  SoSFBool enableHighlight;

  /**
   * Causes the scale tab sizes to be re-adjusted on all 6 SoTabPlaneDraggers so that
   * they remain a near constant screen space size. This happens automatically upon
   * dragger finish. Call this to adjust the scale tab sizes at other times, for
   * instance after the camera has changed in a viewer finish \if_dotnet delegate \else callback \endif\.
   */
  void adjustScaleTabSize();

 SoINTERNAL public:
  static void initClass();  // initialize the class
  static void exitClass();

  int getCurrentState();

protected:

  SoFieldSensor *translFieldSensor;
  SoFieldSensor *scaleFieldSensor;
  SoFieldSensor *resizeHandlesFieldSensor;
	SoFieldSensor *tabPixelSizeFieldSensor;
  SoFieldSensor *privateStyleFieldSensor;

  static void resizeHandlesSensorCB( void *, SoSensor * );
  static void fieldSensorCB( void *, SoSensor * );
  static void valueChangedCB( void *, SoDragger * );
  static void tabPixelSizeSensorCB( void *, SoSensor * );
  static void privateStyleCB(void *, SoSensor *);


  static void invalidateSurroundScaleCB(  void *, SoDragger * );
  static void adjustScaleTabSizeCB(  void *, SoDragger * );

  virtual void handleEvent( SoHandleEventAction *action );
  virtual void handleHighlighting( SoHandleEventAction* action );

  // detach/attach any sensors, callbacks, and/or field connections.
  // Also set geometry of childDraggers to be our default instead of their
  // regular default, using our resources.
  // Called by:            start/end of SoBaseKit::readInstance
  // and on new copy by:   start/end of SoBaseKit::copy.
  // Classes that redefine must call setUpConnections(TRUE,TRUE) 
  // at end of constructor.
  // Returns the state of the node when this was called.
  virtual SbBool setUpConnections( SbBool onOff, SbBool doItAlways = FALSE );

  virtual void setDefaultOnNonWritingFields();

  virtual ~SoTabBoxDragger();

 private:
   // Highlighting
   void applyHighlightingColor();
   void clearHighlight();

   SoSwitch* m_lastHighlightedTabSwitch;
   SoMaterial* m_lastHighlightedPlaneMaterial;
   SoDrawStyle* m_lastHighlightedPlaneDrawStyle;
   static const float s_highlightLineWidth;


  static const char geomBuffer[];
  static SoRef<SoMaterial>   s_tabScaleMatShared;
  static SoRef<SoSeparator>  s_translatorShared;
  static SoRef<SoShapeHints> s_scaleHintsShared;
};    

#endif  /* _SO_TAB_BOX_DRAGGER_ */

