/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TAB_PLANE_DRAGGER_
#define  _SO_TAB_PLANE_DRAGGER_

#include <Inventor/SbLinear.h>
#include <Inventor/sensors/SoSensor.h>
#include <Inventor/projectors/SbLineProjector.h>
#include <Inventor/projectors/SbPlaneProjector.h>
#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/draggers/SoDragger.h>

class SoNode;
class SoCoordinate3;
class SoGLRenderAction;
class SoRayPickAction;
class SoFieldSensor;
class SoSwitch;
class SoShaderProgram;

/**
 * Object you can translate or scale within a plane by dragging with the mouse.
 * 
 * @ingroup draggers
 * 
 * @DESCRIPTION
 *   SoTabPlaneDragger is a dragger which allows the user to interactively translate
 *   and scale in a plane. It looks like a square white outline with smaller green
 *   squares (or @B tabs @b) set in the corners and along the center of each edge.
 *
 *   Dragging a @B corner tab @b scales the dragger in 2D by scaling about the
 *   opposite corner. Holding the @B SHIFT @b key while while dragging a corner tab
 *   forces uniform scaling.
 *
 *   Dragging an @B edge tab @b performs 1D scaling about the opposite edge.
 *
 *   Uniform scaling can also be forced by setting the #scaleUniform field to TRUE.
 *
 *   Clicking and dragging a @B face @b does translation within the plane of the face.
 *   Although the face of the dragger is invisible (using the default dragger geometry)
 *   it is pickable.
 *
 *   The dragger tries to keep the small tabs a constant size in screen space.
 *   Before version 7.0, this adjustment was only done when a drag operation
 *   started and ended, or when the #adjustScaleTabSize method was called.
 *   Now as long as the #resizeHandles field is set to TRUE (the default), the tab
 *   size is automatically recalculated whenever the view matrix changes
 *   (normally because the camera position or orientation changed).  
 *
 *   If the dragger becomes too small in one dimension to contain all three tabs
 *   (two corner tabs plus the edge tab), the middle (edge) tab will not be drawn.
 *   If the dragger becomes very small (or flat) in one dimension, it may not be
 *   possible for the user to resize using the tabs.  One solution for this is to
 *   provide a "reset dragger" button in the application.
 *   
 *   When dragging the translator part, press the \<Shift\> key and you can constrain
 *   motion to either the local @B x axis @b or the @B y axis @b. The direction is
 *   determined by your initial mouse gesture after pressing the key. Releasing the
 *   key removes the constraint.
 *   
 *   When the translator part drags, the dragger updates its #translation field.
 *   The various scaling parts cause changes to both the #scaleFactor and
 *   #translation field, since scaling about a point other than the center adds
 *   translation to the center of the dragger. If you set the field, the dragger will
 *   move accordingly. You can also connect fields of other nodes or engines from
 *   this one to make them follow the dragger's motion.
 *   
 *   You can not change the shape used to draw the tabs. This part is kept privately
 *   and may not be changed; the coordinates for the tabs are edited during
 *   adjustScaleTabSize().
 *   
 *   The SoTabPlaneDragger class does contain three other parts you can change:
 *   @B tabPlaneTranslator @b, @B tabPlaneScaleTabMaterial @b and
 *   @B tabPlaneScaleTabHints @b.
 *   
 *   Each of these is set by default from a resource described in the Dragger
 *   Resources section of the online reference page for this class. You can change
 *   the parts in any instance of this dragger using setPart().
 *   
 *   You can make your program use different default resources for the parts by
 *   copying the file @B $OIVHOME/data/draggerDefaults/tabPlaneDragger.iv @b into
 *   your own directory, editing the file, and then setting the environment variable
 *   @B SO_DRAGGER_DIR @b to be a path to that directory.
 *
 *   See SoDragger for more information about using and customizing draggers,
 *   including code examples, using draggers in an immersive VR environment and using WYSIWYG draggers.
 *   @IMAGE SoTabPlaneDragger.png
 * 
 * @FILE_FORMAT_DEFAULT
 *    TabPlaneDragger {
 *    @TABLE_FILE_FORMAT
 *       @TR boundingBoxCaching   @TD AUTO
 *       @TR renderCulling        @TD AUTO
 *       @TR pickCulling          @TD AUTO
 *       @TR isActive             @TD FALSE
 *       @TR resizeHandles        @TD TRUE
 *       @TR translation          @TD 0 0 0
 *       @TR scaleFactor          @TD 1 1 1
 *       @TR scaleUniform         @TD FALSE
 *       @TR twoSidedLighting      @TD FALSE
 *       @TR lineWidth            @TD 1
 *       @TR tabPixelSize            @TD 8
 *       @TR callbackList         @TD NULL
 *       @TR translator           @TD \<tabPlaneTranslator resource\>
 *       @TR scaleTabMaterial     @TD \<tabPlaneScaleTabMaterial resource\>
 *       @TR scaleTabHints        @TD \<tabPlaneScaleTabHints resource\>
 *    @TABLE_END
 *    }
 * 
 * 
 * @DRAGGER_RESOURCES
 *    @TABLE_DRAGGER_RESOURCES
 *       @TR Resource:      @TD @B tabPlaneTranslator @b
 *       @TR Part:          @TD translator
 *       @TR Appearance:    @TD Outline of a Square. The region within it is pickable
 *       @TR Description:   @TD Begins translation within the plane
 * 
 *       @TR Resource:      @TD @B tabPlaneScaleTabMaterial @b
 *       @TR Part:          @TD scaleTabMaterial
 *       @TR Appearance:    @TD Green - half diffuse, half emissive.
 *       @TR Description:   @TD Used as material for scaling tabs.
 * 
 *       @TR Resource:      @TD @B tabPlaneScaleTabHints @b
 *       @TR Part:          @TD scaleTabHints
 *       @TR Appearance:    @TD shapeHints node:COUNTERCLOCKWISE/SOLID/CONVEX
 *       @TR Description:   @TD Property for the tab nodes.
 * 
 *    @TABLE_END
 * 
 * @CATALOG_PARTS
 *    All Parts
 *    @TABLE_CATALOG_PART
 *       @TR   callbackList         @TD   NodeKitListPart   @TD     --      @TD   yes     
 *       @TR   translator           @TD   Separator         @TD     --      @TD   yes     
 *       @TR   scaleTabMaterial     @TD   Material          @TD     --      @TD   yes     
 *       @TR   scaleTabHints        @TD   ShapeHints        @TD     --      @TD   yes     
 *       @TR   translatorDrawStyle  @TD   DrawStyle         @TD     --      @TD   no
 *       @TR   translatorMaterial   @TD   Material          @TD     --      @TD   no
 *    @TABLE_END
 * 
 *    Extra Information for List Parts from Above Table
 *    @TABLE_LIST_PART
 *       @TR   callbackList      @TD   Separator        @TD   Callback, EventCallback
 *    @TABLE_END
 * 
 * @SEE_ALSO
 *    SoInteractionKit,
 *    SoDragger,
 *    SoCenterballDragger,
 *    SoDirectionalLightDragger,
 *    SoDragPointDragger,
 *    SoHandleBoxDragger,
 *    SoJackDragger,
 *    SoPointLightDragger,
 *    SoRotateCylindricalDragger,
 *    SoRotateDiscDragger,
 *    SoRotateSphericalDragger,
 *    SoScale1Dragger,
 *    SoScale2Dragger,
 *    SoScale2UniformDragger,
 *    SoScaleUniformDragger,
 *    SoSpotLightDragger,
 *    SoTabBoxDragger,
 *    SoTrackballDragger,
 *    SoTransformBoxDragger,
 *    SoTransformerDragger,
 *    SoTranslate1Dragger,
 *    SoTranslate2Dragger
 * 
 * 
 */
class INVENTOR_API SoTabPlaneDragger : public SoDragger
{
  // Define typeId and name stuff
  SO_KIT_HEADER(SoTabPlaneDragger);

  SO_KIT_CATALOG_ENTRY_HEADER(planeSwitch);
  SO_KIT_CATALOG_ENTRY_HEADER(translator);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabs);
  SO_KIT_CATALOG_ENTRY_HEADER(tabsCallback);
  SO_KIT_CATALOG_ENTRY_HEADER(tabsShader);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabMaterial);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabHints);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabMaterialBinding);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabNormalBinding);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabNormal);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleTabPixelSize);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeType0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeType1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeType2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeType3);
  SO_KIT_CATALOG_ENTRY_HEADER(showEdges);
  SO_KIT_CATALOG_ENTRY_HEADER(showCorners);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeTypeCorner0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeTypeCorner1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeTypeCorner2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeTypeCorner3);
  SO_KIT_CATALOG_ENTRY_HEADER(scaleCoords);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScale0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScale1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScale2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScale3);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeSeparator0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeSeparator1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeSeparator2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeSeparator3);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTranslation0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTranslation1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTranslation2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTranslation3);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTab0);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTab1);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTab2);
  SO_KIT_CATALOG_ENTRY_HEADER(edgeScaleTab3);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScale0);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScale1);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScale2);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScale3);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch0);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch1);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch2);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch3);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch4);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch5);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch6);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightSwitch7);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightMaterial0);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightMaterial1);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightMaterial2);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightMaterial3);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighLightMaterial4);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighLightMaterial5);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighLightMaterial6);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighLightMaterial7);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale0);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale1);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale2);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale3);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale4);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale5);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale6);
  SO_KIT_CATALOG_ENTRY_HEADER(tabHighlightScale7);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerSeparator0);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerSeparator1);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerSeparator2);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerSeparator3);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTranslation0);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTranslation1);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTranslation2);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTranslation3);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTab0);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTab1);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTab2);
  SO_KIT_CATALOG_ENTRY_HEADER(cornerScaleTab3);
  SO_KIT_CATALOG_ENTRY_HEADER(translatorMaterial);
  SO_KIT_CATALOG_ENTRY_HEADER(translatorDrawStyle);
  SO_KIT_CATALOG_ENTRY_HEADER(translatorCoordinates);

public:
  /**
  * Constructor.
  */
  SoTabPlaneDragger();

  /**
  * Position of the dragger.  Default is (0,0,0).
  */
  SoSFVec3f translation;
 
  /**
  * Scale factor affecting the dragger.  Default is (1,1,1).
  */
  SoSFVec3f scaleFactor;

  /**
  * If set to TRUE, handles will be resized automatically when the
  * view matrix (camera) changes.  Default is TRUE.
  * 
  * @FIELD_SINCE_OIV 7.0
  */
  SoSFBool resizeHandles;

  /**
  * If set to TRUE, scaling will always be uniform.  Default is FALSE.
  * 
  * @FIELD_SINCE_OIV 7.1
  */
  SoSFBool scaleUniform;

  /**
  * If set to TRUE, OpenGL two sided lighting will be enabled.  Default is FALSE.
  * 
  * @FIELD_SINCE_OIV 7.1
  */
  SoSFBool twoSidedLighting;

  /**
  * Specifies the line width for the outline box.  Default is 1.0
  * 
  * @FIELD_SINCE_OIV 7.1
  */
  SoSFFloat lineWidth;

  /** 
  * Specifies the size of the green tabs in pixels.  Default is 8
  * 
  * @FIELD_SINCE_OIV 9.2
  */
  SoSFInt32 tabPixelSize;

  /**
   * Causes the scale tab sizes to be adjusted so that they remain a near constant
   * screen space size. This happens automatically upon dragger finish. Call this to
   * manually adjust the scale tab sizes at other times, for instance after the camera has
   * changed in a viewer finish \if_dotnet delegate \else callback \endif\.
   * Note that (since version 7.0) handles are automatically resized when the camera
   * changes, as long as the #resizeHandles field is set to TRUE.
   */
  void    adjustScaleTabSize();

  /** show or hide edges */
  void showEdgeScales( const SbBool show );

  /** show or hide corners */
  void showCornerScales( const SbBool show );

 SoINTERNAL public:
  /** register class in database */
  static void initClass();
  /** unregister class from database */
  static void exitClass();

  int getCurrentState();

  void notify( SoNotList* list );

protected:

  //sensor to detect twoSidedLighting changes
  SoFieldSensor *lightingSensor;

  //sensor to detect twoSidedLighting changes
  SoFieldSensor *lineWidthSensor;

  static void lightingSensorCB( void *, SoSensor * );
  static void lineWidthSensorCB( void *, SoSensor * );

  static void startCB( void *, SoDragger *);
  static void motionCB( void *, SoDragger *);
  static void finishCB( void *, SoDragger *);
  static void metaKeyChangeCB( void *, SoDragger *);

  SbLineProjector     *lineProj;
  SbPlaneProjector    *planeProj;

  SoFieldSensor *translFieldSensor;
  SoFieldSensor *scaleFieldSensor;
  static void   fieldSensorCB( void *, SoSensor * );
  static void valueChangedCB( void *, SoDragger * );

  virtual void GLRender( SoGLRenderAction *action );
  virtual void rayPick(SoRayPickAction *action);

  void        dragStart();
  void        drag();
  void        dragFinish();

  void        translateStart();
  void        translateDrag();
    
  void        edgeScaleStart();
  void        edgeScaleDrag();
    
  void        cornerScaleStart();
  void        cornerScaleDrag();
    
  void        scaleUniformStart();
  void        scaleUniformDrag();

  SbVec3f           worldRestartPt;
  int               currentScalePatch;

  enum State {
    INACTIVE, TRANSLATING, EDGE_SCALING, CORNER_SCALING, UNIFORM_SCALING
  };
  SbBool              shftDown;

  State               currentState;
  State               restartState;
  int                 translateDir;

  SbVec3f             scaleCenter;

  // detach/attach any sensors, callbacks, and/or field connections.
  // Called by:            start/end of SoBaseKit::readInstance
  // and on new copy by:   start/end of SoBaseKit::copy.
  // Classes that redefine must call setUpConnections(TRUE,TRUE) 
  // at end of constructor.
  // Returns the state of the node when this was called.
  virtual SbBool setUpConnections( SbBool onOff, SbBool doItAlways = FALSE );

  virtual void setDefaultOnNonWritingFields();

  virtual ~SoTabPlaneDragger();

 private:
  static const char geomBuffer[];
  static bool s_resizeOnInactiveOnly;
  static SoShaderProgram* s_tabsShader;
  static const float s_tabHighlightScaleCoef;
};

#endif  /* _SO_TAB_PLANE_DRAGGER_ */

