/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Jan 2011)
**=======================================================================*/

#if !defined _SO_LASSO_SCREEN_DRAWER_H_
#define _SO_LASSO_SCREEN_DRAWER_H_

#include <Inventor/drawers/SoPolyLineScreenDrawer.h>

/** 
 * @VSGEXT Interactively draw a lasso in normalized screen space.
 *
 * @ingroup drawers
 *
 * @DESCRIPTION
 *   This class can be used to interactively draw a lasso (freeform shape) on screen.
 *
 *   When the lasso is finished, an event is raised to notify the application
 *   (see SoPolyLineScreenDrawer::onFinish ).  Points are returned as normalized
 *   coordinates in the range -1..1, which is conveniently the default view volume
 *   for an SoOrthographicCamera node.
 *
 *   The line color and simplification threshold are specified by
 *   fields in the parent class SoPolyLineScreenDrawer.
 *
 *   Please see SoPolyLineScreenDrawer for general notes and code example.
 *
 *   Lasso specific notes:
 *
 *   - The #simplificationThreshold field does apply to this node.
 *
 *   - If user finishes a lasso, then the next click will automatically clear
 *     the polyline (begin a new lasso).
  *
 *   - SbEventHandlers:
 *     - OnStart : Triggered on LeftMouseDown input event.
 *     - OnMove : Triggered on MouseMove input events (after Start).
 *     - OnFinish : Triggered on LeftMouseUp input event.
*
 *   \if_cpp
 *   [C++] @BR Screen drawer classes must be initialized by calling SoInteraction::init(). High level
 *   viewer init methods, like SoWin::init(), automatically do this. However, if the application
 *   is calling SoDB::init() directly, then it is usually necessary to also call SoInteraction::init()
 *   before using the screen drawer classes.
 *   \endif
 *
 * @USAGE
 * - Press left mouse and drag to draw the lasso.
 * - Release to finish the lasso.
 * - Press Escape to cancel construction of the lasso.
 *
 * @FILE_FORMAT_DEFAULT
 *    LassoScreenDrawer {
 *    @TABLE_FILE_FORMAT
 *       @TR point        @TD []
 *       @TR color        @TD 1 0 0
 *       @TR simplificationThreshold      @TD 5
 *       @TR isClosed     @TD TRUE
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoEllipseScreenDrawer,
 *    SoPolyLineScreenDrawer,
 *    SoPolygonScreenDrawer,
 *    SoRectangleScreenDrawer
 */
class INVENTOR_API SoLassoScreenDrawer : public SoPolyLineScreenDrawer 
{
  SO_NODE_HEADER( SoLassoScreenDrawer );

public:
  /** Constructor */
  SoLassoScreenDrawer();

  /** @copydoc SoPolyLineScreenDrawer::reset() */
  virtual void reset();

SoINTERNAL public:

  /** Register in database */
  static void initClass();

  /** Unregister from database */
  static void exitClass();

SoEXTENDER_Documented protected:

  /** Called when key down. Finish lasso. */
  virtual void onKeyDown( SoHandleEventAction* action );

  /** Called when user click. Start a new lasso. */
  virtual void onMouseDown( SoHandleEventAction* action );

  /** 
   * Called when the mouse is dragging. Append the current mouse position to 
   * drawing lasso. 
   */
  virtual void onMouseDragging( SoHandleEventAction* action );

  /** Called when user release the mouse button. Finish the lasso. */
  virtual void onMouseUp( SoHandleEventAction* action );

protected:

  /** Destructor */
  virtual ~SoLassoScreenDrawer();

private:

  /** Finalize the lasso: ensure line have 2 points, remove duplicated points, etc... */
  void finalizeLasso( SoHandleEventAction* action );

private:

  /** Position of last added point (in px). Used to avoid add point every pixels. */
  SbVec2s m_lastAddedPoint;

};


#endif // _SO_LASSO_SCREEN_DRAWER_H_


