/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Jan 2011)
**=======================================================================*/

#if !defined _SO_POLYGON_SCREEN_DRAWER_H_
#define _SO_POLYGON_SCREEN_DRAWER_H_

#include <Inventor/drawers/SoPolyLineScreenDrawer.h>

/** 
 * @VSGEXT Interactively draws a polygon in normalized screen space.
 *
 * @ingroup drawers
 *
 * @DESCRIPTION
 *   This class can be used to interactively draw a polygon on screen.
 *
 *   When the polygon is finished, an event is raised to notify the application
 *   (see SoPolyLineScreenDrawer::onFinish ).  Points are returned as normalized
 *   coordinates in the range -1..1, which is conveniently the default view volume
 *   for an SoOrthographicCamera node.
 *
 *   The line color and simplification threshold are specified by
 *   fields in the parent class SoPolyLineScreenDrawer.
 *
 *   Please see SoPolyLineScreenDrawer for additional notes and code example.
 *
 *   Polygon specific notes:
 *
 *   - The #simplificationThreshold field does apply to this node.
 *
 *   - If the user finishes a polygon and the application does not call the
 *     \if_dotnet Clear() \else clear() \endif method, then the next click
 *     will add another point to the existing polygon.
 *
 *   - SbEventHandlers:
 *     - OnStart : Triggered on initial LeftMouseDown input event.
 *     - OnMove : Triggered on MouseMove input events (after Start) @BR
 *                and @I also @i on LeftMouseDown and LeftMouseUp input events (after Start).
 *     - OnFinish : Triggered on LeftMouseDoubleClick input event @BR
 *                or KeyPress input event with \<Enter\> or \<ESC\> keys.
 *
 *   \if_cpp
 *   [C++] @BR Screen drawer classes must be initialized by calling SoInteraction::init(). High level
 *   viewer init methods, like SoWin::init(), automatically do this. However, if the application
 *   is calling SoDB::init() directly, then it is usually necessary to also call SoInteraction::init()
 *   before using the screen drawer classes.
 *   \endif
 *
 * @USAGE
 * - Left click to add a point.
 * - Double-click to add a point and finish the polygon.
 * - Press Enter to finish the polygon (with the points added so far).
 * - Press Escape to cancel creation of the polygon.
 * 
 * @FILE_FORMAT_DEFAULT
 *    PolygonScreenDrawer {
 *    @TABLE_FILE_FORMAT
 *       @TR point        @TD []
 *       @TR color        @TD 1 0 0
 *       @TR simplificationThreshold      @TD 5
 *       @TR isClosed     @TD TRUE
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoEllipseScreenDrawer,
 *    SoLassoScreenDrawer,
 *    SoPolyLineScreenDrawer,
 *    SoRectangleScreenDrawer
 */
class INVENTOR_API SoPolygonScreenDrawer : public SoPolyLineScreenDrawer 
{
  SO_NODE_HEADER( SoPolygonScreenDrawer );

public:
  /** Constructor */
  SoPolygonScreenDrawer();

  virtual void clear() { SoPolyLineScreenDrawer::clear(); m_lastAddedPoint = SbVec2s(-1, -1); }

SoINTERNAL public:

  /** Register in database */
  static void initClass();

  /** Unregister from database */
  static void exitClass();

SoEXTENDER_Documented protected:

  /** Finish polygon line. */
  virtual void onKeyDown( SoHandleEventAction* action );

  /** Move last polygon point. */
  virtual void onMouseMove( SoHandleEventAction* action );

  /** Add a point to polygon. */
  virtual void onMouseDown( SoHandleEventAction* action );

  /** Finish creation of polygon. */
  virtual void onMouseDblClick( SoHandleEventAction* action );

protected:

  /** Destructor */
  virtual ~SoPolygonScreenDrawer();

private:

  /** Is a polyline is creating. */
  inline bool isCreating() const { return m_lastAddedPoint[0] != -1 && m_lastAddedPoint[1] != -1; }

  /** Last added point, in px. If (-1, -1), polyline is not creating. */
  SbVec2s m_lastAddedPoint;

};


#endif // _SO_POLYGON_SCREEN_DRAWER_H_


