/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Jul 1997)
**=======================================================================*/

                                                             /* include files */
#ifndef  _SO_ANNOT_TEXT3_CHAR_ORIENT_ELEMENT_
#define  _SO_ANNOT_TEXT3_CHAR_ORIENT_ELEMENT_

#include <Inventor/elements/SoInt32Element.h>

/*----------------------------------------------------------------------------*/
/**
* @VSGEXT Stores the current character orientation flag of an SoAnnoText3Property node.
*
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current character orientation flag of an SoAnnoText3Property node.
*   @SEE_ALSO
*   SoAnnoText3Property
*/

SoEXTENDER_Documented class INVENTOR_API SoAnnoText3CharOrientElement : public SoInt32Element {
  
  SO_ELEMENT_HEADER(SoAnnoText3CharOrientElement);
  
 public:

  /**
  *  Sets the value in the state.
  */
  static void set(SoState *state, SbBool isOriented);
  
  /**
  *  Returns the current value from the state.
  */
  static SbBool get(SoState *state);
  
  /**
  *  Returns the default value.
  */
  static SbBool getDefault();

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
//  Initializes the class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoAnnoText3CharOrientElement();
} ;

/*----------------------------------------------------------------------------*/

#endif /* _SO_ANNOT_TEXT3_CHAR_ORIENT_ELEMENT_  */


