/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_BBOX_MODEL_MATRIX_ELEMENT
#define  _SO_BBOX_MODEL_MATRIX_ELEMENT

#include <Inventor/SbBasic.h>
#include <Inventor/elements/SoModelMatrixElement.h>

#ifdef _DEBUG
#include <Inventor/threads/SbThreadLocalStorage.h>
#endif

/**
* Stores the current model matrix for use with the
*   SoGetBoundingBoxAction.
*
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current model matrix for use with the
*   SoGetBoundingBoxAction. Overrides the virtual methods on
*   SoModelMatrixElement to also set the current
*   SoLocalBBoxMatrixElement.
* 
*   This class relies on SoModelMatrixElement to store the matrix in
*   the instance, and inherits most of its methods from it.
*   @SEE_ALSO
*   SoTransformSeparator, SoResetTransform
* 
*/

SoEXTENDER_Documented class INVENTOR_API SoBBoxModelMatrixElement : public SoModelMatrixElement {

  SO_ELEMENT_HEADER(SoBBoxModelMatrixElement);

 public:

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void        push(SoState *state);

  /**
  *  Allows the SoGetBoundingBoxAction to reset the current model
  *  matrix to identity and all currently-open local matrices to
  *  identity.
  */
  static void         reset(SoState *state, SoNode *node);

  /**
  *  Because two model matrices are kept track of during the
  *  getBoundingBoxAction (the local model matrix, used by
  *  separators to calculate their bbox caches, and the real model
  *  matrix), replacement routines for pushMatrix/popMatrix must be
  *  given; SoTransformSeparator::getBoundingBox uses these methods to
  *  correctly keep both matrices up-to-date.
  * [OIVJAVA-WRAPPER NO_WRAP]
  */
  static void         pushMatrix(SoState *state,
                                 SbMatrix &matrix,
                                 SbMatrix &localmatrix);
  /**
  * See description for pushMatrix().
  */
  static void         popMatrix(SoState *state,
                                const SbMatrix &matrix,
                                const SbMatrix &localmatrix);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoBBoxModelMatrixElement class
  static void         initClass();
  static void         exitClass();

  /**
   * Same as pushMatrix with taking into account forward traversal matrix.
   * [OIV-WRAPPER NO_WRAP]
   */
  static void pushForwardMatrix(SoState *state, SbMatrix &matrix, SbMatrix &ftmatrix, SbMatrix &localmatrix);

  /**
   * Same as popMatrix with taking into account forward traversal matrix.
   * [OIV-WRAPPER NO_WRAP]
   */
  static void popForwardMatrix(SoState *state, const SbMatrix &matrix, const SbMatrix &ftmatrix, const SbMatrix &localmatrix);

 protected:
  // These all override the methods on SoModelMatrixElement to also
  // set the SoLocalBBoxMatrixElement
  virtual void        makeEltIdentity();
  virtual void        setElt(const SbMatrix &matrix);
  virtual void        setElt(const SbMatrix &matrix, SbBool sendToGL);
  virtual void        multElt(const SbMatrix &matrix);
  virtual void        translateEltBy(const SbVec3f &translation);
  virtual void        rotateEltBy(const SbRotation &translation);
  virtual void        scaleEltBy(const SbVec3f &scaleFactor);

  // These must never be called; they print debug errors if called:
  virtual SbMatrix    pushMatrixElt();
  virtual void        popMatrixElt(const SbMatrix &m);

  virtual ~SoBBoxModelMatrixElement();

 private:
  // Stores pointer to state so we can access the SoLocalBBoxMatrixElement
  SoState* state;

#ifdef _DEBUG
  // This is used to make sure the pushMatrix/popMatrix methods are
  // called correctly.
  struct MTstruct
  {
    bool pushPopCallOK;
  };
  SB_THREAD_TLS_HEADER();
#endif

};

inline void
SoBBoxModelMatrixElement::setElt(const SbMatrix &matrix, SbBool )
{
  setElt(matrix);
}

#endif /* _SO_BBOX_MODEL_MATRIX_ELEMENT */


