/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_BBox_TYPE_ELEMENT
#define  _SO_BBox_TYPE_ELEMENT

#include <Inventor/elements/SoInt32Element.h>

/**
* @VSGEXT Stores the current BBox type.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current BBox type.
*
*   @SEE_ALSO
*   SoComplexity
*/
SoEXTENDER_Documented class INVENTOR_API SoBBoxTypeElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoBBoxTypeElement);

public:
  /**
  *  Available BBox types:
  */
  enum Type {
    // Axis aligned (default)
    BBOX_AABB,
    // Object oriented
    BBOX_OOB
  };

  /**
  *  Sets the current BBox type in the state.
  */
  static void set(SoState *state, Type type);

  /**
  *  Sets the current BBox type in the state.
  */
  static void         set(SoState *state, SoNode *, Type type)
  { set(state, type); }

  /**
  *  Returns current BBox type from the state.
  */
  static Type         get(SoState *state)
  { return (Type)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default BBox type.
  */
  static Type         getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  SoINTERNAL public:
  // Initializes the SoBBoxTypeElement class
  static void         initClass();
  static void         exitClass();

protected:
  virtual ~SoBBoxTypeElement();
};

#endif /* _SO_BBox_TYPE_ELEMENT */


