/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_BEVEL_PROPERTY_ELEMENT
#define  _SO_BEVEL_PROPERTY_ELEMENT

#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/nodes/SoBevelProperty.h>

/**
* @VSGEXT Stores various beveling attributes.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores various beveling attributes.
*   @SEE_ALSO
*   SoBevelProperty
*/
SoEXTENDER_Documented class INVENTOR_API SoBevelPropertyElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoBevelPropertyElement);

 public:

  /**
  *  Sets the bevel angle: if 2 adjacent faces make a greater angle,
  *  then their common edge is beveled.
  */
  static void   setAngle(SoState *state, SoNode *node, float);
  /**
  *  Sets the bevel radius as a percentage [0.0, 1.0]
  *  of the greater value of the length of each edge.
  */
  static void   setRadius(SoState *state, SoNode *node, float = SoBevelProperty::DEFAULT_RADIUS);
  /**
  *  Sets the bevel radius as an absolute value.
  */
  static void   setAbsoluteRadius(SoState *state, SoNode *node, float);

  /**
  *  Allows the user to switch on/off the tests applied
  *  before the bevel (can increase speed when the tests are not needed).
  */
  static void   setTests(SoState *state, SoNode *node, int);

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoBevelPropertyElement * getInstance(SoState *state)
    {return getConstElement<SoBevelPropertyElement>(state);}

  /**
  *  Gets the bevel properties (angle).
  */
  float         getAngle() const                {return angle;}
  /**
  *  Gets the bevel properties (radius).
  */
  float         getRadius() const               {return radius;}
  /**
  *  Gets the bevel properties (absolute radius).
  */
 SbBool        isAbsoluteRadius() const        {return absoluteRadius;}
  /**
  *  Gets the bevel properties (enabled flag).
  */
 SbBool        isEnabled() const               {return propertyEnabled;}
  /**
  *  Method to know if this test is enabled. If it is, this
  *  test will be performed on each shape before the bevel.
  */
  SbBool        isCoplanarTestEnabled() const {return tests & SoBevelProperty::COPLANAR_TEST;}
  /**
  *  Method to know if this test is enabled. If it is, this
  *  test will be performed on each shape before the bevel.
  */
  SbBool        isDuplicateTestEnabled() const {return tests & SoBevelProperty::DUPLICATE_TEST;}
  /**
  *  Method to know if this test is enabled. If it is, this
  *  test will be performed on each shape before the bevel.
  */
  SbBool        isOrderingTestEnabled() const {return tests & SoBevelProperty::ORDERING_TEST;}
  /**
  *  Method to know the different tests currently selected;
  *  these tests will be performed on each shape before beveling is applied.
  */
  int           getTestsToDoBeforeBevel() const {return tests;}

  /**
  *  Prints element (for debugging).
  */
  virtual void  print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoBevelPropertyElement class
  static void           initClass();
  static void           exitClass();

 protected:
  float         angle, radius;
  SbBool        absoluteRadius, propertyEnabled;
  int           tests;

  virtual ~SoBevelPropertyElement();
};

#endif /* _SO_BEVEL_PROPERTY_ELEMENT */


