/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Dec 2008)
**=======================================================================*/

#ifndef  SO_DEPTH_OFFSET_ELEMENT_H
#define  SO_DEPTH_OFFSET_ELEMENT_H

#include <Inventor/elements/SoFloatElement.h>

/**
 * @VSGEXT Manage SoDepthOffset nodes accumulation in state.
 * 
 * @ingroup elements
 * 
 *   @DESCRIPTION
 *   This element stores SoDepthOffset nodes encountered during traversal at
 *   any given time. Requesting for current offset at a given time
 *   (throught get() method) returns the global accumulated offset, computed
 *   from all previously SoDepthOffset nodes encountered in current path traversal.
 *
 */

SoEXTENDER_Documented class INVENTOR_API SoDepthOffsetElement : public SoFloatElement
{

  SO_ELEMENT_HEADER(SoDepthOffsetElement);
  
public:

  /** Sets the current offset in the state. */
  static void set(SoState *state, float offset);

  /** Sets the current offset in the state. */
  static void set(SoState *state, SoNode *, float offset);

  /** Sets the current offset in the state. */
  static void set(SoState *state, float, float, float);

  /** Returns current accumulated offset from the state. */
  static float get(SoState *state);

  /** Sets the current offset in the state. */
  static void setMaxOffset(SoState *state, float offset);

  /** Returns current accumulated offset from the state. */
  static float getMaxOffset(SoState *state);

  /** Push the element into the state. */
  virtual void push( SoState* );

  /** Pop the element from the state. */
  virtual void pop(SoState*, const SoElement*);

protected:

  /** @copydoc SoElement::init() */
  virtual void init(SoState *state);

SoINTERNAL public:
  // Initializes the class
  static void initClass();
	static void exitClass();

  /** Sets the normalization factor needed to normalize depth offset when the
      sum of all offsets in the scene graph is greater than a given factor. */
  static void setNormalizationFactor(SoState *state, float value);

  /** Get the normalization factor. */
  static float getNormalizationFactor(SoState *state);

  /** Sets the normalization factor needed to normalize depth offset when the
  sum of all offsets in the scene graph is greater than a given factor. */
  static void setNDCadjustment(SoState *state, float value);

  /** Get the normalization factor. */
  static float getNDCadjustment(SoState *state);

  /** eval global factors from provided maxOffset */
  static void evalGlobalFactors(float offset, float& NDCadjustment, float &normFactor);

  // Specify the version of depth offset used :
  // V1 : Depth offset modifies camera projection matrix
  // V2 : Depth offset modifies projection matrix only here
  //      To have the same behavior than V1, you have to add a DepthOffset node
  //      with an offset at 0 on the root of the scene graph.
  enum DepthOffsetVersion
  {
    NONE = -1,
    V1 = 1,
    V2
  };

  /**
   * Return the current version of depth offset to use
   * Related to OIV_DEPTHOFFSET_VERSION
   */
  static DepthOffsetVersion getDepthOffsetVersion();

  /**
   * Copy depth offset properties from one state to another
   */
  static void copyDepthOffset( SoState* dstState, SoState* srcState );

protected:
  virtual ~SoDepthOffsetElement();

  float maxOffset;
  float localdata;
  float normalizationFactor;
  float NDCadjustment;

private :

  static DepthOffsetVersion s_depthOffsetVersion;
};

#endif // SO_DEPTH_OFFSET_ELEMENT_H


