/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_FLOAT_ELEMENT
#define  _SO_FLOAT_ELEMENT


/**
*   Element's subclasses store a single float, int, or enum value.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element's subclasses store a single float, int, or enum value. This class
*   defines generic matches() and copy() methods.
*
*   @SEE_ALSO
*/

#include <Inventor/elements/SoSubElement.h>

SoEXTENDER_Documented class INVENTOR_API SoFloatElement : public SoElement {

  SO_ELEMENT_ABSTRACT_HEADER(SoFloatElement);

public:
  /** @copydoc SoElement::print */
  virtual void        print(FILE *fp) const;

protected:

  /**
  *  Comparison based on value of floats
  */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, takes care copying the data. */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoFloatElement class
  static void         initClass();
  static void         exitClass();

  // Set value.  Derived classes have static inline methods
  // that pass in the stack index and cast their type into a float.
  // This just gets an appropriate instance and calls the virtual
  // set.
  //static void         set(int stackIndex, SoState *state, float value);
  static void         set(SoType type, int stackIndex, SoState *state, float value);

  // Get value.  Derived classes have static inline methods to pass
  // in the stackIndex and cast the returned value to the right type.

  static float        get(SoType type, int stackIndex, SoState *state)
  {return (static_cast<const SoFloatElement*>(getConstElement(state, type, stackIndex)))->data;}

  // Get the value from the element itself
  float getValue() const { return data; }

 protected:
  // Storage for data.
  float data;

  // Destructor
  virtual ~SoFloatElement();

  // Virtual set that subclasses can override to implement
  // side-effect behaviors.
  virtual void        setElt(float value);
};

#endif /* _SO_FLOAT_ELEMENT */


