/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_FONT_SIZE_ELEMENT
#define  _SO_FONT_SIZE_ELEMENT

#include <Inventor/SbString.h>
#include <Inventor/elements/SoFloatElement.h>

/**
*   Stores the current font size.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current font size.
*
*   @SEE_ALSO
*   SoFont, SoFontStyle
*/

SoEXTENDER_Documented class INVENTOR_API SoFontSizeElement : public SoFloatElement {

  SO_ELEMENT_HEADER(SoFontSizeElement);

 public:
  /**
  *  Sets the current font size.
  */
  static void         set(SoState *state, float size)
    { SoFloatElement::set(getClassTypeId(), getClassStackIndex(), state, size); }

  /**
  *  Sets the current font size.
  */
  static void         set(SoState *state, SoNode *, float size)
    { set(state, size); }

  /**
  *  Returns the current font size from the state.
  */
  static float get(SoState *state);

  /**
  *  Returns the default font size.
  */
  static float  getDefault();

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *state);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
   *  Comparison based on value of floats
   */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, takes care copying the data. */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes class
  static void         initClass();
  static void         exitClass();

  /** 
   * Polygon text is rendered with a size > 1 to avoid freetype precision error
   * But it then needs to be scaled down by this size during rendering/bbox computation.
   * This method set a scaled version of the font size to be used by polgon text
   * renderer (see ebug#5423).
   */
  static void enablePolygonFontSizeScale(SoState* state);

  /* retrieve if font size is scaled */
  static bool isScaled(SoState *state);

  /** Return the size used for polygon text rendering */
  static unsigned int getPolygonFontSize()
  {
    return s_polygonFontSize;
  }

 protected:
  virtual ~SoFontSizeElement();

 private:
  static float s_defaultFontSize;
  static bool s_isSet;

  /** Size used by freetype to render font in polygon mode */
  const static unsigned int s_polygonFontSize;

  /** Scale applied on the font size */
  float m_scale;
  /** flag to know if font size is scaled */
  bool m_isScaled;
};

#endif /* _SO_FONT_SIZE_ELEMENT */


