/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas Daguise (Nov 2003)
**=======================================================================*/

#ifndef  _SO_FULL_SCENE_ANTIALIASING_ELEMENT_
#define  _SO_FULL_SCENE_ANTIALIASING_ELEMENT_

#include <Inventor/elements/SoSubElement.h>
/**
* @VSGEXT Stores the current Full-Scene Antialising state.
*
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current Full-Scene Antialising state.
*   @SEE_ALSO
*   SoFullSceneAntialiasing, SoWinGLWidget, SoXtGLWidget, SoQtGLWidget
*/

SoEXTENDER_Documented class INVENTOR_API SoFullSceneAntialiasingElement : public SoElement {

  SO_ELEMENT_HEADER(SoFullSceneAntialiasingElement);

 public:
   /** Filter */
  enum Filter {
    /** Points */
    POINTS   = 0x01,
    /** Lines */
    LINES    = 0x02,
    /** Polygons */
    POLYGONS = 0x04,
    /** Text */
    TEXT     = 0x08,
    /** All */
    ALL      = LINES | POINTS | POLYGONS | TEXT
  };

  /**
  *  Sets the current Full-Scene Antialising attributes in the state.
  */
  static void set(SoState *state, SbBool on, SbBool currOn, int filter);

  /**
   * @brief Set the sample count to be used for Full-Scene Antialiasing.
   * @param state The current state.
   * @param sampleCount The number of samples per pixel.
   */
  static void setSampleCount(SoState *state, uint8_t sampleCount);

  /**
  *  Gets the current Full-Scene Antialising attributes in the state.
  */
  static SbBool get(SoState *state, SbBool &on, SbBool &pointsOn, SbBool &linesOn, SbBool &polygonsOn, SbBool &textsOn, int& filter);
  
  /**
  *  Push copies the values from the previous element.
  */
  virtual void  push(SoState *state);

  /**
  *  Returns the top (current) instance of the element in the state.
  *  Note it does NOT cause cache dependency!
  *  It also casts away the const.
  */
  static SoFullSceneAntialiasingElement * getInstance(const SoState *state);

  /**
  *  Returns the default values.
  */
  static SbBool getDefault(SbBool &on, SbBool &pointsOn, SbBool &linesOn, SbBool &polygonsOn, SbBool &textsOn, int& filter, uint8_t& sampleCount);

  /**
  *  Returns the default values.
  */
  static SbBool getDefault(SbBool &on, SbBool &pointsOn, SbBool &linesOn, SbBool &polygonsOn, SbBool &textsOn, int& filter);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the attributes of polygon offset  match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Creates and returns a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoFullSceneAntialiasingElement class
  static void initClass();
  static void exitClass();

 protected:
  SbBool m_on;
  uint8_t m_sampleCount;
  int  m_filterMask;
  SbBool m_pointsOn;
  SbBool m_linesOn;
  SbBool m_polygonsOn;
  SbBool m_textOn;

  virtual void setElt(SbBool on, SbBool currOn, int filter);

  virtual void setElt(uint8_t sampleCount);

  virtual ~SoFullSceneAntialiasingElement();
};

#endif /* _SO_FULL_SCENE_ANTIALIASING_ELEMENT_ */


