/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Julien SALLANNE (May 2009)
**=======================================================================*/

#ifndef  _SO_GEO_ORIGIN_ELEMENT
#define  _SO_GEO_ORIGIN_ELEMENT

#include <Inventor/SbLinear.h>
#include <Inventor/elements/SoReplacedElement.h>

/**
* @VSGEXT Stores the current geoOrigin
* 
* @ingroup elements
* 
*   @DESCRIPTION
* 
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoGeoOriginElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoGeoOriginElement);

 public:
  /**
  *  Sets the current attributes.
  */
  static void set(SoState *state, SoNode *node, SbBool rotateYUp, const SbVec3f &geoOrigin);

  /**
  *  Returns the current attributes from the state.
  */
  static void get( SoState *state, SbBool &rotateYUp, SbVec3f &geoOrigin );

  /**
  *  Returns the default values.
  */
  static void getDefault( SbBool &rotateYUp, SbVec3f &geoOrigin );

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

  /**
  *  Returns TRUE if the geoOrigins match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

 SoINTERNAL public:
  // Initializes the SoGeoOriginElement class
  static void         initClass();
  static void         exitClass();

 protected:
  SbVec3f             geoOrigin;
  SbBool              rotateYUp;

  virtual ~SoGeoOriginElement();
};

#endif /* _SO_GEO_ORIGIN_ELEMENT */


