/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef SO_INTERACTION_ELEMENT_H
#define SO_INTERACTION_ELEMENT_H

#include <Inventor/elements/SoInt32Element.h>

/**
 *   @VSGEXT Stores the current interaction state.
 *
 * @ingroup elements
 *
 *   @DESCRIPTION
 *   This element stores the current interaction state.
 *
 * @SEE_ALSO
 *  SoWinRenderArea, SoXtRenderArea, SoQtRenderArea
 */

SoEXTENDER_Documented class INVENTOR_API SoInteractionElement : public SoElement
{
  SO_ELEMENT_HEADER(SoInteractionElement);

public:

  /**
   *  Sets the current interaction in the state.
   */
  static void set(SoState *state, bool moving);

  /**
   *  Returns TRUE if a user interaction with the viewer
   *  is in progress.
   */
  static bool isInteracting(SoState *state);

  /**
   * Return number of frames since last interaction flag change
   */
  static uint32_t getElapsedFrames(SoState* state);

  /**
   * Return number of seconds since last interaction flag change
   */
  static double getElapsedSeconds(SoState* state);

protected:

  /**
   *  Common initialization
   */
  virtual void commonInit();

  /** @copydoc SoElement::matches() */
  virtual SbBool matches(const SoElement* elt) const;

  /** @copydoc SoElement::copyMatchInfo() */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  bool isInteracting() const;

protected:
  void setElt(SoState *state, bool moving);

  virtual ~SoInteractionElement();

  struct
  {
    /** [OIV-WRAPPER-NO-WRAP] */
    bool interacting;
    /** [OIV-WRAPPER-NO-WRAP] */
    uint32_t numFrames;
    /** [OIV-WRAPPER-NO-WRAP] */
    double startTime;
    /** [OIV-WRAPPER-NO-WRAP] */
  } m_interactionInfos;
};

#endif // SO_INTERACTION_ELEMENT_H


