/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_INTERACTIVE_COMPLEXITY_ELEMENT
#define  _SO_INTERACTIVE_COMPLEXITY_ELEMENT

#include <Inventor/elements/SoAccumulatedElement.h>
#include <Inventor/STL/vector>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class SoInteractiveComplexity;
class SoSField;
class SoSFBool;
class SoSFEnum;

/**
 * @VSGEXT Stores the current interactive complexity.
 *
 * @ingroup elements
 *
 *   @DESCRIPTION
 *   This element stores the current interactive complexity.
 *
 *   @SEE_ALSO
 *   SoInteractiveComplexity
*/

SoEXTENDER_Documented class INVENTOR_API SoInteractiveComplexityElement : public SoAccumulatedElement
{
  SO_ELEMENT_HEADER(SoInteractiveComplexityElement);

 public:

  /** Set the current SoInteractiveComplexity node */
  static void set(SoState *state, SoInteractiveComplexity* node);

  /** Return value of scalar field as a double */
  static double getScalarFieldValue(SoState *state,
                                    const SoSField* field);

  /** Return value of a SoSFBool */
  static SbBool getBooleanFieldValue(SoState *state, const SoSFBool* field);

  /** Return value of a SoSFEnum */
  static int getEnumFieldValue(SoState *state, const SoSFEnum* field);

  /**
   *  Overrides push() method to copy values from next instance in the stack.
   */
  virtual void push(SoState *state) ;

  /** Pop method. */
  virtual void pop(SoState *, const SoElement *prevTopElement) ;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoInteractiveComplexityElement class
  static void         initClass();
  static void         exitClass();

  /** Return value of field as a double */
  static double getCurrentScalarFieldValue(const SoSField* field);

  /** Return true if the field is bounded  */
  static bool isBounded(SoState* state, const SoSField* field);

  /** Return the last node on the state */
  static const SoInteractiveComplexity* getLast(SoState *state);

 protected:
  typedef std::vector<SoInteractiveComplexity*> ComplexityVector;
  typedef ComplexityVector::const_reverse_iterator ComplexityVectorConstRevIt;

  /** Return the last complexity on state which change this field */
  SoInteractiveComplexity* findComplexity(const SoSField* field) const;

  /** Return value of field as a double */
  double getScalarFieldValueInternal(SoState* state, const SoSField* field) const;
  SbBool getBooleanFieldValueInternal(SoState* state, const SoSFBool* field) const;
  int getEnumFieldValueInternal(SoState* state, const SoSFEnum* field) const;

  void setElt(SoState *state, SoInteractiveComplexity* node);

  virtual ~SoInteractiveComplexityElement();

  /** List of SoInteractiveComplexity */
  ComplexityVector m_nodeList;

  //Element has been pushed at this point
  size_t m_startIndex;
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _SO_COMPLEXITY_ELEMENT */


