/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_LIGHT_MODEL_ELEMENT
#define _SO_LIGHT_MODEL_ELEMENT

#include <Inventor/SbBasic.h>
#include <Inventor/elements/SoReplacedElement.h>

class SoState;
class SoNode;

/**
*   Stores the current lighting model.
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current lighting model.
* 
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoLightModelElement : public SoElement {

 SO_ELEMENT_HEADER(SoLightModelElement);

 public:
 /**
 *  These are the available lighting models.
 */
 enum Model {
 /**
 *  No lighting; just use base color.
 */
 BASE_COLOR,
 /**
 *  Phong lighting.
 */
 SoDEPRECATED_ENUM_VALUE(10000, "PHONG is replaced by PER_VERTEX_PHONG to avoid ambiguities with PER_PIXEL_PHONG")
 PHONG,
 /**
 *  Per-vertex Phong lighting.
 */
 PER_VERTEX_PHONG,
 /**
 *  Per-pixel Phong lighting.
 */
 PER_PIXEL_PHONG,

   /** Physically based lighting */
   PHYSICALLY_BASED,
  }; 

  /**
  *  Sets the current lighting model in the state.
  */
 static void set(SoState *state, Model model);
  /**
  *  Sets the current lighting model in the state.
  */
 static void set(SoState *state, SoNode *, Model model);
  
  /**
  *  Returns current lighting model from the state.
  */
 static Model get(SoState *state);
  
  /**
  *  Returns the default lighting model.
  */
 static Model getDefault();

SoINTERNAL public:
 static void initClass();
 static void exitClass();

  /** Specifies how the viewing vector used for specular reflections is computed */
  enum ViewVectorType
  {
    /**
     * The view direction is parallel to and in the direction of the -z axis.
     *
     * The resulting specular reflections will be correct for Orthographic cameras
     * but not for Perspective cameras or other types of projections.
     *
     * In GLSL: viewVector = vec3(0.0, 0.0, 1.0);
     */
    FIXED,

    /**
     * The view direction is the direction of the origin of the camera space
     * (i.e. the eye space position of the camera).
     *
     * The resulting specular reflections will be correct for Perspective cameras
     * but not for Orthographic cameras or other types of projections.
     *
     * In GLSL: viewVector = -normalize(viewSpacePosition.xyz);
     */
    ORIGIN,

    /**
     * The view direction is computed by projecting the view-space position on the near and far planes of the view volume,
     * then computing the normalized direction defined by the difference between the two projected points in view space.
     *
     * The resulting specular reflections will be correct for all types of projections,
     * at the cost of a more expensive computation of the view vector.
     */
    PROJECTION,
  };

  /**
   * Returns the default view vector type.
   */
  static ViewVectorType getDefaultViewVectorType();

  /**
   * Sets the current view vector type in the state.
   */
  static void setViewVectorType(SoState* state, ViewVectorType viewVectorType);

  /**
   * Returns the current view vector type on the state.
   */
  static ViewVectorType getViewVectorType(SoState* state);

  /** @copydoc SoElement::push() */
  void push(SoState* state) override;

protected:
  /**Comparison of element */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, takes care copying the data. */
  virtual SoElement* copyMatchInfo() const;

  virtual void init(SoState *state);

  virtual ~SoLightModelElement();

private:
  Model m_model;
  ViewVectorType m_viewVecType;
};

#endif /* _SO_LIGHT_MODEL_ELEMENT */

