/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_LOCAL_BBOX_MATRIX_ELEMENT
#define  _SO_LOCAL_BBOX_MATRIX_ELEMENT

#include <Inventor/elements/SoModelMatrixElement.h>

/**
*   Stores the transformation matrix from object space to
*   some local coordinate space during application of an
*   SoGetBoundingBoxAction.
* 
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the transformation matrix from object space to
*   some local coordinate space during application of an
*   SoGetBoundingBoxAction. This element is needed to allow separators
*   (and other caching nodes) to store cached bounding boxes in their
*   own local space. Shapes that extend the current bounding box
*   computed by the action use this matrix to transform the bounding
*   box into local space. Separators cache this box, then transform it
*   into the next local space up the hierarchy.
* 
*   Because this element is set to identity by separators before
*   traversing their children, it can never have an affect on any
*   caching separator that it is not under. Therefore, it should
*   never be tested for cache invalidation, so its matches() method
*   prints an error message and returns FALSE. It also means that it
*   does not have to save node id's so there are no nodes passed in to
*   any of the methods.
* 
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoLocalBBoxMatrixElement : public SoElement {

  SO_ELEMENT_HEADER(SoLocalBBoxMatrixElement);

 public:
  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void        push(SoState *state);

  /**
  *  Sets the local matrix to the identity matrix.
  */
  static void         makeIdentity(SoState *state);

  /**
  *  Sets the local matrix to the given matrix.
  */
  static void         set(SoState *state, const SbMatrix &matrix);

  /**
  *  Multiplies the given matrix into the local matrix.
  */
  static void         mult(SoState *state, const SbMatrix &matrix);

  /**
  *  Multiplies a matrix that performs the specified
  *  transformation into the local matrix.
  */
  static void         translateBy(SoState *state,const SbVec3f &translation);
  /**
  *  Multiplies a matrix that performs the specified
  *  transformation into the local matrix.
  */
  static void         rotateBy(SoState *state, const SbRotation &rotation);
  /**
  *  Multiplies a matrix that performs the specified
  *  transformation into the local matrix.
  */
  static void         scaleBy(SoState *state, const SbVec3f &scaleFactor);

  /**
  *  This method is used by the TransformSeparator node.
  */
  static SbMatrix     pushMatrix(SoState *state);
  /**
  *  This method is used by the TransformSeparator node.
  */
  static void         popMatrix(SoState *state, const SbMatrix &m);

  /**
  *  Resets all current instances in the state to identity.
  */
  static void         resetAll(SoState *state);

  /**
  *  Returns current matrix from the state.
  */
  static const SbMatrix &     get(SoState *state);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Prints error message and returns FALSE (see class header comment).
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoLocalBBoxMatrixElement class
  static void         initClass();
  static void         exitClass();

 protected:
  SbMatrix            localMatrix;

  virtual ~SoLocalBBoxMatrixElement();

 private:
  // This stores the inverse of the current model matrix at the time
  // the element is created. It is needed in case the element is set
  // to contain a new matrix, since we want to factor out the
  // effects of the non-local part of the matrix.
  SbMatrix            modelInverseMatrix;
};

#endif /* _SO_LOCAL_BBOX_MATRIX_ELEMENT */


