/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Pierre Stefani (MMM yyyy)
**=======================================================================*/

#ifndef  _SO_LOGICAL_VIEW_PORT_ELEMENT
#define  _SO_LOGICAL_VIEW_PORT_ELEMENT

#include <Inventor/SbViewportRegion.h>
#include <Inventor/elements/SoSubElement.h>

/**
*   @VSGEXT Stores the logical viewport region.
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the logical viewport region, which indicates
*   to the camera(s) the whole size of the window which is being rendered
*   into. This information is needed when the viewport region has been
*   split, so that the camera doesn't adjust its parameters on only
*   a part of the whole window.
* 
*   LogicalViewportElement is used for "tiled" rendering -- in this case
*   it contains the size (and aspect ratio) of the complete large image,
*   while ViewportRegionElement contains the size of the tile (subimage)
*   we are currently rendering. SoCamera::computeView uses the logical
*   viewport's aspect ratio for ADJUST_CAMERA mode, so we render all the
*   tiles with the same adjustment (but only if the LogicalViewportElement
*   was actually set during traversal -- see SoOffscreenRenderArea).
* 
*   @SEE_ALSO
*   PoBaseView, SoOffscreenRenderArea, SoGLRenderAction
*/

SoEXTENDER_Documented class INVENTOR_API SoLogicalViewportElement : public SoElement {
  
  SO_ELEMENT_HEADER(SoLogicalViewportElement);
  
 public:
  /**
  *  Sets the viewport region.
  */
  static void set(SoState *state, const SbViewportRegion &vp);
  
  /**
  *  Returns the current viewport region from the state.
  */
  static const SbViewportRegion &get(SoState *state);

  /**
  *  Returns the default viewport region.
  */
  static SbViewportRegion getDefaultViewport()
    { return SbViewportRegion(SbVec2s(100, 100)); }

  /**
  *  Return the top (current) instance of the element in the state.
  *  Note it does NOT cause cache dependency!
  *  It also casts away the const.
  */
  static SoLogicalViewportElement *getInstance(const SoState *state, 
                                               SbBool &elemIsSet);

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the passes match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
    // Initializes the SoLogicalViewportElement class
  static void initClass();
  static void exitClass();
  
 protected:

  virtual ~SoLogicalViewportElement();

private:
  SbViewportRegion m_viewport;
  SbBool m_isSet;
};
#endif /* _SO_LOGICAL_VIEW_PORT_ELEMENT */

