/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MATERIAL_BINDING_ELEMENT
#define  _SO_MATERIAL_BINDING_ELEMENT

#include <Inventor/elements/SoSubElement.h>
#include <Inventor/SbVertexAttributeBinding.h>

/**
*   Stores the current material binding.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current material binding.
*
*   @SEE_ALSO
*   SoMaterialBinding, SoVertexProperty
*/

SoEXTENDER_Documented class INVENTOR_API SoMaterialBindingElement : public SoElement {

  SO_ELEMENT_HEADER(SoMaterialBindingElement);

 public:
 /**
 *  The choice of values is for compatibility
 *  with Open Inventor 2.0 binary format files.
 */
 enum Binding {
   /**
   *  Whole object has same material.
   */
   OVERALL = SbVertexAttributeBinding::OVERALL,
   /**
   *  One material for each part of object.
   */
   PER_PART = SbVertexAttributeBinding::PER_PART,
   /**
   *  One material for each part, indexed.
   */
   PER_PART_INDEXED = SbVertexAttributeBinding::PER_PART_INDEXED,
   /**
   *  One material for each face of object.
   */
   PER_FACE = SbVertexAttributeBinding::PER_FACE,
   /**
   *  One material for each face, indexed.
   */
   PER_FACE_INDEXED = SbVertexAttributeBinding::PER_FACE_INDEXED,
   /**
   *  One material for each vertex.
   */
   PER_VERTEX = SbVertexAttributeBinding::PER_VERTEX,
   /**
   *  One material for each vertex, indexed.
   */
   PER_VERTEX_INDEXED = SbVertexAttributeBinding::PER_VERTEX_INDEXED

   // Obsolete bindings:
   ,                       // Comma to continue list
   DEFAULT = OVERALL,
   NONE = OVERALL

  };

  /** @copydoc SoMaterialBinding::Face */
  enum Face
  {
    /** @copydoc SoMaterialBinding::FRONT */
    FRONT = 1,

    /** @copydoc SoMaterialBinding::BACK */
    BACK,

    /** @copydoc SoMaterialBinding::FRONT_AND_BACK */
    FRONT_AND_BACK,
  };

  /**
  *  Sets the current material binding in the state.
  */
  static void set(SoState* state, Binding binding);

  /**
  *  Sets the current material binding in the state.
  */
  static void         set(SoState *state, SoNode *, Binding binding)
    { set(state, binding); }

  /**
   * Sets the current face binding in the state.
   */
  static void setFace(SoState* state, Face face);

  /**
  *  Returns the current material binding from the state.
  */
  static Binding get(SoState* state);

  /**
   * Returns the current face binding from the state.
   */
  static Face getFace(SoState* state);

  /**
  *  Returns the default material binding.
  */
  static Binding      getDefault()            { return OVERALL; }

  /**
   * Returns the default material binding face.
   */
  static Face getDefaultFace()
  {
    return FRONT_AND_BACK;
  }

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

  /** @copydoc SoElement::push() */
  void push(SoState* state) override;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /** @copydoc SoElement::matches() */
  SbBool matches(const SoElement* elt) const override;

  /** @copydoc SoElement::copyMatchInfo() */
  SoElement* copyMatchInfo() const override;

 SoINTERNAL public:
  // Initializes the SoMaterialBindingElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoMaterialBindingElement();

private:
  Binding m_binding;
  Face m_face;
};

#endif /* _SO_MATERIAL_BINDING_ELEMENT */


