/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SO_MATERIAL_ELEMENT
#define _SO_MATERIAL_ELEMENT

#include <Inventor/SbBasic.h>
#include <Inventor/SbColor.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/elements/SoSubElement.h>
#include <Inventor/devices/SoCpuBufferObject.h>
#include <math.h>

class SoMFFloat;
class SoMFColor;
class SbThreadMutex;

/**
 Store in the state the material properties set by some property nodes.

@ingroup elements

  @DESCRIPTION

 The values of this element are modified by property nodes that affects the material
 characteristics such as: SoBaseColor, SoMaterial, SoPhysicalMaterial.

  @SEE_ALSO
  SoBaseColor, SoPhysicalMaterial, SoMaterial, SoPackedColor, SoVertexProperty
*/

SoEXTENDER_Documented class INVENTOR_API SoMaterialElement : public SoReplacedElement {
  SO_ELEMENT_HEADER(SoMaterialElement);

 public:

 /** Masks */
 enum masks {
   /** Color mask */
   COLOR_MATERIAL_MASK = 1 << 1,
   /** Diffuse mask */
   DIFFUSE_MASK = 1 << 2,
   /** Ambient mask */
   AMBIENT_MASK = 1 << 3,
   /** Emissive mask */
   EMISSIVE_MASK = 1 << 4,
   /** Specular mask */
   SPECULAR_MASK = 1 << 5,
   /** Shininess mask */
   SHININESS_MASK = 1 << 6,
   /** Transparency mask */
   TRANSPARENCY_MASK = 1 << 8,
   /** All masks */
   ALL_MASK = 0xFFFF,
 };

  /**
   * Faces
   */
  enum Face
  {
    /** Front Face */
    FRONT,

    /** Back Face */
    BACK,
  };

  /**
   * Static set method.
   * [OIV-WRAPPER-ARG IN,IN,IN,NO_WRAP{(colors != NULL? colors->Length: 0)},ARRAY,IN]
   */
  static void setDiffuse(SoState* state, Face face, SoNode* node, int32_t numColors, const SbColor* colors);

  /**
   * Static set method.
   * [OIV-WRAPPER-ARG IN,IN,IN,NO_WRAP{(transp != NULL? transp->Length: 0)},ARRAY,IN]
   */
  static void setTransparency(SoState* state, Face face, SoNode* node, int32_t numTransp, const float* transp);

  /**
   * [OIV-WRAPPER-ARG IN,IN,IN,NO_WRAP{(colors != NULL? colors->Length: 0)},ARRAY]
   */
  static void setPacked(SoState* state, Face face, SoNode* node, int32_t numColors, const uint32_t* colors);
  
  /**
   * Static set method.
   * [OIV-WRAPPER-ARG IN,IN,IN,NO_WRAP{(indices != NULL? indices->Length: 0)},ARRAY]
   */
  static void setColorIndices(SoState* state, Face face, SoNode* node, int32_t numIndices, const int32_t* indices);

  static void setAmbient(SoState* state, Face face, SoNode* node, const SbColor& color);
  static void setEmissive(SoState* state, Face face, SoNode* node, const SbColor& color);
  static void setSpecular(SoState* state, Face face, SoNode* node, const SbColor& color);

  static void setShininess(SoState* state, Face face, SoNode* node, float value);
  static void setColorMaterial(SoState* state, Face face, SoNode* node, SbBool value);

  // Physically based parameters
  static void setSpecularFactor(SoState* state, Face face, SoNode* node, float value);
  static void setRoughness(SoState* state, Face face, SoNode* node, float value);
  static void setMetallic(SoState* state, Face face, SoNode* node, float value);

  /**
   * get() methods get value from Inventor state. The public methods are
   * static, they get an instance of the element.
   */
  static SbColor getDiffuse(SoState* state, Face face, int index);

  /**
   * get() methods get value from Inventor state. The public methods are
   * static, they get an instance of the element.
   */
  static float getTransparency(SoState* state, Face face, int index);

  /** Return packed colors if any */
  static SoCpuBufferObject* getPackedColors(SoState* state, Face face);

  /**
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{GetNumColorIndices(state)}]
   * [OIVJAVA-WRAPPER-RETURN-TYPE ARRAY{getNumColorIndices(state)}]
   */
  static const int32_t* getColorIndices(SoState* state, Face face);

  static int32_t getColorIndex(SoState* state, Face face, int num);

  static const SbColor& getAmbient(SoState* state, Face face);
  static const SbColor& getEmissive(SoState* state, Face face);
  static const SbColor& getSpecular(SoState* state, Face face);
  static float getShininess(SoState* state, Face face);

  static SbBool getColorMaterial(SoState* state, Face face);

  // Physically based parameters
  static float getSpecularFactor(SoState* state, Face face);
  static float getRoughness(SoState* state, Face face);
  static float getMetallic(SoState* state, Face face);

  /**
   * Returns the number of diffuse colors
   */
  static size_t getNumDiffuse(SoState* state, Face face);

  /**
   * Method to inquire about current colors.
   */
  static size_t getNumColorIndices(SoState* state, Face face);

  /**
  *  Method to inquire about current colors.
  */
  static int32_t getNumTransparencies(SoState* state, Face face);

  /**
  *  Method to inquire about current colors.
  */
  static bool isTransparent( SoState* state );

  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static float getDefaultAmbientIntensity() {
    return 0.2F;
  }

  /**
  * Specify Open Inventor defaults for colors, etc.
  */
  static SbColor getDefaultDiffuse() {
    return SbColor(0.8F, 0.8F, 0.8F);
  }
  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static SbColor getDefaultAmbient() {
    return SbColor(0.2F, 0.2F, 0.2F);
  }
  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static SbColor getDefaultSpecular() {
    return SbColor(0.0F, 0.0F, 0.0F);
  }
  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static SbColor getDefaultEmissive() {
    return SbColor(0.0F, 0.0F, 0.0F);
  }
  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static float getDefaultShininess() {
    return 0.2F;
  }

  // Physically based parameters

  static float getDefaultSpecularFactor()
  {
    return 0.0f;
  }

  static float getDefaultRoughness()
  {
    return 0.8f;
  }

  static float getDefaultMetallic()
  {
    return 0.0f;
  }

  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static float getDefaultTransparency() {
    return 0.0F;
  }
  /**
  * Specify Open Inventor defaults for colors, etc.
  */
   static int32_t getDefaultColorIndex() {
    return 1;
  }

  /** Copy current material into the pushed element */
  virtual void push(SoState *state);
  /** Unref buffer object of the popped element */
  virtual void pop( SoState* state, const SoElement* prevTopElement );

#if SoDEPRECATED_BEGIN(2025100)
  /**
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(colors != NULL? colors->Length: 0)},ARRAY,IN]
   */
  SoDEPRECATED_METHOD(2025.1, "Use the setDiffuse() method that takes a Face parameter instead.")
  static void setDiffuse(SoState* state, SoNode* node, int32_t numColors, const SbColor* colors)
  {
    setDiffuse(state, FRONT, node, numColors, colors);
  }

  /**
   * Static set method.
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(transp != NULL? transp->Length: 0)},ARRAY,IN]
   */
  SoDEPRECATED_METHOD(2025.1, "Use the setTransparency() method that takes a Face parameter instead.")
  static void setTransparency(SoState* state, SoNode* node, int32_t numTransp, const float* transp)
  {
    setTransparency(state, FRONT, node, numTransp, transp);
  }

  /**
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(colors != NULL? colors->Length: 0)},ARRAY]
   */
  SoDEPRECATED_METHOD(2025.1, "Use the setPacked() method that takes a Face parameter instead.")
  static void setPacked(SoState* state, SoNode* node, int32_t numColors, const uint32_t* colors)
  {
    setPacked(state, FRONT, node, numColors, colors);
  }

  /**
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(indices != NULL? indices->Length: 0)},ARRAY]
   */
  SoDEPRECATED_METHOD(2025.1, "Use the setColorIndices() method that takes a Face parameter instead.")
  static void setColorIndices(SoState* state, SoNode* node, int32_t numIndices, const int32_t* indices)
  {
    setColorIndices(state, FRONT, node, numIndices, indices);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setAmbient() method that takes a Face parameter instead.")
  static void setAmbient(SoState* state, SoNode* node, const SbColor& color)
  {
    setAmbient(state, FRONT, node, color);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setEmissive() method that takes a Face parameter instead.")
  static void setEmissive(SoState* state, SoNode* node, const SbColor& color)
  {
    setEmissive(state, FRONT, node, color);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setSpecular() method that takes a Face parameter instead.")
  static void setSpecular(SoState* state, SoNode* node, const SbColor& color)
  {
    setSpecular(state, FRONT, node, color);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setShininess() method that takes a Face parameter instead.")
  static void setShininess(SoState* state, SoNode* node, float value)
  {
    setShininess(state, FRONT, node, value);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setColorMaterial() method that takes a Face parameter instead.")
  static void setColorMaterial(SoState* state, SoNode* node, SbBool value)
  {
    setColorMaterial(state, FRONT, node, value);
  }

  // Physically-based parameters

  SoDEPRECATED_METHOD(2025.1, "Use the setSpecularFactor() method that takes a Face parameter instead.")
  static void setSpecularFactor(SoState* state, SoNode* node, float value)
  {
    setSpecularFactor(state, FRONT, node, value);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setRoughness() method that takes a Face parameter instead.")
  static void setRoughness(SoState* state, SoNode* node, float value)
  {
    setRoughness(state, FRONT, node, value);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the setMetallic() method that takes a Face parameter instead.")
  static void setMetallic(SoState* state, SoNode* node, float value)
  {
    setMetallic(state, FRONT, node, value);
  }


  SoDEPRECATED_METHOD(2025.1, "Use the getDiffuse() method that takes a Face parameter instead.")
  static SbColor getDiffuse(SoState* state, int index)
  {
    return getDiffuse(state, FRONT, index);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getTransparency() method that takes a Face parameter instead.")
  static float getTransparency(SoState* state, int index)
  {
    return getTransparency(state, FRONT, index);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getPackedColors() method that takes a Face parameter instead.")
  static SoCpuBufferObject* getPackedColors(SoState* state)
  {
    return getPackedColors(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getColorIndices() method that takes a Face parameter instead.")
  static const int32_t* getColorIndices(SoState* state)
  {
    return getColorIndices(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getColorIndex() method that takes a Face parameter instead.")
  static int32_t getColorIndex(SoState* state, int num)
  {
    return getColorIndex(state, FRONT, num);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getAmbient() method that takes a Face parameter instead.")
  static const SbColor& getAmbient(SoState* state)
  {
    return getAmbient(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getEmissive() method that takes a Face parameter instead.")
  static const SbColor& getEmissive(SoState* state)
  {
    return getEmissive(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getSpecular() method that takes a Face parameter instead.")
  static const SbColor& getSpecular(SoState* state)
  {
    return getSpecular(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getShininess() method that takes a Face parameter instead.")
  static float getShininess(SoState* state)
  {
    return getShininess(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getColorMaterial() method that takes a Face parameter instead.")
  static SbBool getColorMaterial(SoState* state)
  {
    return getColorMaterial(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getSpecularFactor() method that takes a Face parameter instead.")
  static float getSpecularFactor(SoState* state)
  {
    return getSpecularFactor(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getRoughness() method that takes a Face parameter instead.")
  static float getRoughness(SoState* state)
  {
    return getRoughness(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getMetallic() method that takes a Face parameter instead.")
  static float getMetallic(SoState* state)
  {
    return getMetallic(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getNumDiffuse() method that takes a Face parameter instead.")
  static size_t getNumDiffuse(SoState* state)
  {
    return getNumDiffuse(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getNumColorIndices() method that takes a Face parameter instead.")
  static size_t getNumColorIndices(SoState* state)
  {
    return getNumColorIndices(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getNumTransparencies() method that takes a Face parameter instead.")
  static int32_t getNumTransparencies(SoState* state)
  {
    return getNumTransparencies(state, FRONT);
  }
#endif /** @DEPRECATED_END */

protected:

  /** @copydoc SoElement::commonInit() */
  virtual void commonInit();

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  * @copydoc SoElement::matches()
  * note: matches, copyMatchinfo must not be used by this element.
  * they are replaced by lazyMatches, copyMaterialMatchInfo, on SoGLMaterialElement.
  * Returns TRUE
  */
  virtual SbBool matches(const SoElement *) const;

  /** @copydoc SoElement::copyMatchInfo()
  * note: matches, copyMatchinfo must not be used by this element.
  * they are replaced by lazyMatches, copyMaterialMatchInfo, on SoGLMaterialElement.
  * Returns NULL
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:

  // set method for use in SoMaterial nodes:
  static void setMaterials(SoState* state,
                           Face face,
                           SoNode* node,
                           uint32_t bitmask,
                           const SoMFColor &diffuse,
                           const SoMFFloat &transp,
                           const SoMFColor &ambient,
                           const SoMFColor &emissive,
                           const SoMFColor &specular,
                           const SoMFFloat &shininess);

  // Prints element (for debugging)
  virtual void print(FILE *fp) const;

  // Initializes the SoMaterialElement class
  static void initClass();
  static void exitClass();

  static const SbColor* getDiffusePointer(SoState* state, Face face);
  const SbColor* getDiffusePointer(Face face) const;

  static const int32_t* getColorIndexPointer(SoState* state, Face face);
  static const float* getTransparencyPointer(SoState* state, Face face);
  const float* getTransparencyPointer(Face face) const;

  static void setHasTransparency( SoState* state, SoNode* node, int hasTransparency );

  static const SoMaterialElement* getInstance( SoState* state );

  const SbColor& getAmbient(Face face) const;
  const SbColor& getEmissive(Face face) const;
  const SbColor& getSpecular(Face face) const;
  float getShininess(Face face) const;

  // Physically based parameters
  float getSpecularFactor(Face face) const;
  float getRoughness(Face face) const;
  float getMetallic(Face face) const;

  int32_t getNumDiffuse(Face face) const
  {
    return m_materialProperties[face].numDiffuseColors;
  }

  int32_t getNumColorIndices(Face face) const
  {
    return (m_materialProperties[face].colorIndices ? m_materialProperties[face].numDiffuseColors : 0);
  }

  int32_t getNumTransparencies(Face face) const;
  bool isTransparent() const;
  SoCpuBufferObject* getPackedColors(Face face) const;

  bool isPacked(Face face) const
  {
    return m_materialProperties[face].packedColors.ptr() != nullptr;
  }

#if SoDEPRECATED_BEGIN(2025100)

  SoDEPRECATED_METHOD(2025.1, "Use the setMaterials() method that takes a Face parameter instead.")
  static void setMaterials(SoState* state, SoNode* node, uint32_t bitmask,
                           const SoMFColor& diffuse, const SoMFFloat& transp, const SoMFColor& ambient,
                           const SoMFColor& emissive, const SoMFColor& specular, const SoMFFloat& shininess)
  {
    setMaterials(state, FRONT, node, bitmask, diffuse, transp, ambient, emissive, specular, shininess);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getDiffusePointer() method that takes a Face parameter instead.")
  static const SbColor* getDiffusePointer(SoState* state)
  {
    return getDiffusePointer(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getDiffusePointer() method that takes a Face parameter instead.")
  const SbColor* getDiffusePointer() const
  {
    return getDiffusePointer(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getColorIndexPointer() method that takes a Face parameter instead.")
  static const int32_t* getColorIndexPointer(SoState* state)
  {
    return getColorIndexPointer(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getTransparencyPointer() method that takes a Face parameter instead.")
  static const float* getTransparencyPointer(SoState* state)
  {
    return getTransparencyPointer(state, FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getTransparencyPointer() method that takes a Face parameter instead.")
  const float* getTransparencyPointer() const
  {
    return getTransparencyPointer(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getAmbient() method that takes a Face parameter instead.")
  const SbColor& getAmbient() const
  {
    return getAmbient(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getEmissive() method that takes a Face parameter instead.")
  const SbColor& getEmissive() const
  {
    return getEmissive(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getSpecular() method that takes a Face parameter instead.")
  const SbColor& getSpecular() const
  {
    return getSpecular(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getShininess() method that takes a Face parameter instead.")
  float getShininess() const
  {
    return getShininess(FRONT);
  }

  // Physically-based parameters

  SoDEPRECATED_METHOD(2025.1, "Use the getSpecularFactor() method that takes a Face parameter instead.")
  float getSpecularFactor() const
  {
    return getSpecularFactor(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getRoughness() method that takes a Face parameter instead.")
  float getRoughness() const
  {
    return getRoughness(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getMetallic() method that takes a Face parameter instead.")
  float getMetallic() const
  {
    return getMetallic(FRONT);
  }


  SoDEPRECATED_METHOD(2025.1, "Use the getNumDiffuse() method that takes a Face parameter instead.")
  int32_t getNumDiffuse() const
  {
    return getNumDiffuse(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getNumColorIndices() method that takes a Face parameter instead.")
  int32_t getNumColorIndices() const
  {
    return getNumColorIndices(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getNumTransparencies() method that takes a Face parameter instead.")
  int32_t getNumTransparencies() const
  {
    return getNumTransparencies(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the getPackedColors() method that takes a Face parameter instead.")
  SoCpuBufferObject* getPackedColors() const
  {
    return getPackedColors(FRONT);
  }

  SoDEPRECATED_METHOD(2025.1, "Use the isPacked() method that takes a Face parameter instead.")
  bool isPacked() const
  {
    return isPacked(FRONT);
  }

#endif /** @DEPRECATED_END */

protected:  
  //Struct to hold material parameters
  struct Material
  {
    public:
    Material()
    {
      //The memset ensure that we are also clearing the possible padding
      //which is needed when doing memcmp in match method
      memset(this, 0, sizeof(Material));
      dirtyPackedColor = true;
      packedColorExplicitelySet = false;
    }
    const SbColor *diffuseColors;
    SoRef<SoCpuBufferObject> packedColors;
    const float *transparencies;
    const int32_t *colorIndices;

    SbColor ambientColor;
    SbColor emissiveColor;
    SbColor specularColor;
    float shininess;
    int32_t colorMaterial;

    // Physically based parameters
    float specularFactor;
    float roughness;
    float metallic;

    int32_t numDiffuseColors;
    int32_t numTransparencies;

    //True if we need to recreate the packed color buffer
    bool dirtyPackedColor : 1;

    bool packedColorExplicitelySet : 1;
  };

  // 2 for front & back materials
  Material m_materialProperties[2];

  virtual ~SoMaterialElement();

  // store the default color, transp so that we can set
  // point to them if no other color or transp has been set.
  static SbColor s_defaultDiffuseColor;
  static float s_defaultTransparency;
  static int32_t s_defaultColorIndices;
  static SoCpuBufferObject* s_defaultPackedColorBuffer;

  // -1 = don't know yet, 0 = no transp, 1 = has transp
  int m_hasTransparency;

 private:
  /**
   * Get a Writable instance, so will force a push if needed.
   * If node is NULL, the nodeId will be set to the last value on state.
   */
  static SoMaterialElement* getWInstance( SoState* state, SoNode* node = nullptr );

  /** Return colors in a uint32_t packed form */
  SoCpuBufferObject* packDiffuseColors(Face face);
  
  void setDiffuseElt(Face face, int32_t numColors, const SbColor *colors);
  void setColorIndexElt(Face face, int32_t numIndices, const int32_t *indices);
  void setTranspElt(Face face, int32_t numTrans, const float *trans);
  void setAmbientElt(Face face, const SbColor *color);
  void setEmissiveElt(Face face, const SbColor *color);
  void setSpecularElt(Face face, const SbColor *color);
  void setShininessElt(Face face, float value);
  void setColorMaterialElt(Face face, SbBool value);
  void setMaterialElt(Face face, uint32_t bitmask,
                      const SoMFColor &, const SoMFFloat &, const SoMFColor &,
                      const SoMFColor &, const SoMFColor &, const SoMFFloat &);

  // Physically based parameters
  void setSpecularFactorElt(Face face, float value);
  void setRoughnessElt(Face face, float value);
  void setMetallicElt(Face face, float value);

  static const float S_SHINY_THRESHOLD;
};

#endif /* _SO_MATERIAL_ELEMENT */

