/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Aug 2013)
**=======================================================================*/
#if !defined _SO_MULTIPLE_INSTANCE_ELEMENT_H_
#define _SO_MULTIPLE_INSTANCE_ELEMENT_H_

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbMatrix.h>

class SoMultipleInstance;


/**
* Stores current MultiInstance info.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current multiple instance information.
*
*   @SEE_ALSO
*   SoMultipleInstance, SoMultipleCopy, SoShape
*/
class INVENTOR_API SoMultipleInstanceElement : public SoReplacedElement
{
  SO_ELEMENT_HEADER(SoMultipleInstanceElement);

public:
  /** Sets the current multiple instance node */
  static void set(SoState* state, SoNode* node, SoMultipleInstance* instanceproperty);

  /** Returns the number of shape instance requests in the state. */
  static unsigned int getNumInstances(SoState* state);

  /** Returns the current element in the state */
  static SoMultipleInstance* get(SoState* state);
   
  /** returns the default element value. */
  static SoMultipleInstance* getDefault();

  /** Return the number of batches */
  static unsigned int getNumBatches(SoState * state);

SoINTERNAL public:
  /** @copydoc SoElement::initClass() */
  static void initClass();

  /** @copydoc SoElement::exitClass() */
  static void exitClass();

  /** getters for instancing parameters */
  inline const SbMatrix& getInstanceModelMatrix () const { return m_oivInstanceModelMatrix; }
  inline unsigned int getNumInstances() const { return m_numInstances; }
  inline unsigned int getNumInstancedBatches() const { return m_numBatches; }
  inline unsigned int getCurrentBatchNumber() const { return m_currentBatchNum; }
  inline int32_t getNeedParamsBits() const { return m_needParamsBits; }

  /** setters */
  inline void setCurrentBatchNumber( uint32_t currentBatchNum ) { m_currentBatchNum = currentBatchNum; }
  inline void setNeedParamsBits( int32_t needParamsBits ) { m_needParamsBits = needParamsBits; }

protected:
  /** @copydoc SoElement::init() */
  virtual void init(SoState* state);

  /** @copydoc SoElement::copyMatchInfo() */
  virtual SoElement *copyMatchInfo() const;

  /** @copydoc SoElement::matches() */
  virtual SbBool matches(const SoElement* elt) const;

private:
  SoMultipleInstance* m_shapeInstanceProperty;

  SbMatrix m_oivInstanceModelMatrix;

  unsigned int m_numInstances;
  unsigned int m_numBatches;
  unsigned int m_currentBatchNum;

  int32_t m_needParamsBits;
};


#endif // _SO_MULTIPLE_INSTANCE_ELEMENT_H_

