/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Jan 2009)
**=======================================================================*/

#ifndef  _SO_NEIGHBOR_TOLERANCE_ELEMENT
#define  _SO_NEIGHBOR_TOLERANCE_ELEMENT

#include <Inventor/elements/SoFloatElement.h>

/**
* @VSGEXT Stores the current neighbor tolerance factor.
*
* @ingroup elements
*
* @DESCRIPTION
* Specifies the tolerance value to use when default normals are computed.
* Specifically it determines which (other) points in the shape are close
* enough to influence the normal at each vertex.
* Setting a smaller tolerance value will select a smaller number of points
* and can reduce the time required for computing normals on very large,
* very dense geometry.
*
* The default is 10e-5.
*
* If the OIV_NORMGEN_TOLERANCE environment variable is set, the default is
* 1/OIV_NORMGEN_TOLERANCE.
*
* @SEE_ALSO SoShapeHints, SoPreferences.
*/

SoEXTENDER_Documented class INVENTOR_API SoNeighborToleranceElement : public SoFloatElement {

  SO_ELEMENT_HEADER(SoNeighborToleranceElement);

 public:
   /**
   *  Sets the current tolerance factor in the state.
   */
    static void         set(SoState *state, float tolerance);

  /**
  *  Returns current tolerance factor from the state.
  */
  static float        get(SoState *state)
    { return SoFloatElement::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  * Returns the default tolerance factor value.
  */
  static inline float getDefault()
  { return s_defaultTolerance; }

  /**
  * set the default tolerance factor value.
  */
  static void setDefault(const float tolerance);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element in the state. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  /** Register SoNeighborToleranceElement in database. */
  static void         initClass();
  /** Unregister SoNeighborToleranceElement in database. */
  static void         exitClass();

 protected:
  /** Destructor. */
  virtual ~SoNeighborToleranceElement();

private:
  /** default tolerance factor value */
  static float s_defaultTolerance;
};

#endif /* _SO_NEIGHBOR_TOLERANCE_ELEMENT */


