/*=======================================================================
* Copyright 1991-1996, Silicon Graphics, Inc.
* ALL RIGHTS RESERVED
*
* UNPUBLISHED -- Rights reserved under the copyright laws of the United
* States.   Use of a copyright notice is precautionary only and does not
* imply publication or disclosure.
*
* U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
* Use, duplication or disclosure by the Government is subject to restrictions
* as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
* in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
* in similar or successor clauses in the FAR, or the DOD or NASA FAR
* Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
* 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
*
* THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
* INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
* DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
* PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
* GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_PICK_METHOD_ELEMENT
#define  _SO_PICK_METHOD_ELEMENT

#include <Inventor/elements/SoInt32Element.h>

/**
*   Stores the current pick method.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current pick method.
*
*   @SEE_ALSO
*   SoPickMethod
*/

SoEXTENDER_Documented class INVENTOR_API SoPickMethodElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoPickMethodElement);

public:
  /**
  *  These are the available pick methods.
  */
  enum Method {
    /**
    *  OIV is in charge of selecting the best method to use when picking a shape
    */
    AUTO,
    /**
    *  Force using GPU picking if the shape supports it
    */
    GPU,
    /**
    *  Force using CPU picking, even if shape supports other picking method
    */
    CPU
  };

  /**
  *  Sets the current pick method in the state.
  */
  static void         set(SoState *state, Method method)
  {
    SoInt32Element::set(getClassTypeId(), getClassStackIndex(), state, (int32_t)method);
  }

  /**
  *  Sets the current pick method in the state.
  */
  static void         set(SoState *state, SoNode *, Method method)
  {
    set(state, method);
  }

  /**
  *  Returns current pick method from the state.
  */
  static Method        get(SoState *state)
  {
    return (Method)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state);
  }

  /**
  *  Returns the default pick method.
  */
  static Method        getDefault()            { return AUTO; }

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  SoINTERNAL public:
    // Initializes/unload the SoPickMethodElement class
    static void         initClass();
    static void         exitClass();

protected:
  virtual ~SoPickMethodElement();
};

#endif /* _SO_PICK_METHOD_ELEMENT */


