/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_REPLACED_ELEMENT
#define  _SO_REPLACED_ELEMENT

/**
*   Abstract base class for each state element whose value
*   is replaced whenever it is set
*
* @ingroup elements
*
*   @DESCRIPTION
*   This is the abstract base class for each state element whose value
*   is replaced whenever it is set. (Most state elements fall into
*   this category, so most are derived from this class.)
*
*   This class overrides the SoElement::getElement() method to store
*   the node-id of the node that is about to set the value in the
*   element (i.e., the node that is passed to getElement()). This
*   class also defines the SoElement::matches() method to return TRUE
*   if the node-id's of the two elements match. Subclasses can change
*   this behavior by defining matches() differently, if they wish. For
*   example, they can compare the elements' values, instead.
*
*   @SEE_ALSO
*/

#include <Inventor/elements/SoSubElement.h>

SoEXTENDER_Documented class INVENTOR_API SoReplacedElement : public SoElement {

  SO_ELEMENT_ABSTRACT_HEADER(SoReplacedElement);

 public:

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes node id in element (directly called by constructor) */
  virtual void commonInit();

  /**  Initializes node id in element */
  virtual void init(SoState *state);

  /**
  * Create and return a copy of this element.  The only operation
  * supported by the copy is matches() (the copy will be
  * unitialized except for the nodeId).
  */
  virtual SoElement* copyMatchInfo() const;

  /**
  *  Returns TRUE if the element matches another element, based on node-id.
  */
  virtual SbBool matches(const SoElement* elt) const;

 SoINTERNAL public:
  // Initializes the SoReplacedElement class
  static void         initClass();
  static void         exitClass();

  // Return nodeId.  This was added so the SoTransformSeparator
  // class can figure out whether or not it contains a camera:
  uint64_t getNodeId() const { return nodeId; }

  // Sets the current nodeId.
  void setNodeId( uint64_t id ) { nodeId = id; }

 protected:

  // Overrides SoElement::getElement() to set the nodeId in the
  // element instance before returning it.
  static SoElement *  getElement(SoState *state, SoType type, int stackIndex,
                                 SoNode *node);

  /**
   * [OIV-WRAPPER CUSTOM_CODE]
   */
  template<typename T>
  static T* getElement(SoState *state, SoNode *node)
  {
    return static_cast<T*>(getElement(state, T::getClassTypeId(), T::getClassStackIndex(), node));
  }

  // Destructor
  virtual ~SoReplacedElement();

private:
  uint64_t nodeId;

};

#endif /* _SO_REPLACED_ELEMENT */


