/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_SHADER_PROGRAM_ELEMENT_
#define  _SO_SHADER_PROGRAM_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/misc/SoRef.h>
#include <Inventor/nodes/SoShaderProgram.h>

class SoGLShaderProgram ;
class SoGLRenderAction;

/**
* @VSGEXT Stores the current shader program.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current shader program.
*
*   @SEE_ALSO
*   SoShaderProgram
*/
SoEXTENDER_Documented class INVENTOR_API SoShaderProgramElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoShaderProgramElement);

public:


  /**
  *  Sets the current shader program in the state.
  */
  static void set(SoState *state, SoNode *node);

  /**
  *  Gets the current shader program in the state.
  */
  static void get(SoState *state, SoShaderProgram *&);

  /**
  *  Overrides push() method so side effects can occur in GL.
  */
  virtual void push(SoState *) ;

  /**
  *  Overrides pop() method so side effects can occur in GL.
  */
  virtual void pop(SoState *state, const SoElement *prevTopElement);

protected:

  /**
   * Set a bigger priority than SoGLUniformShaderElement in order to be sure
   * to have the good active shader when doing the set uniform.
   */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

SoINTERNAL public:
  // Initializes the classes.
  static void initClass();
  static void exitClass();

  /** Get the current pushed element if any */
  static const SoShaderProgramElement* get(SoState *state);

  /** True if shader is active for OpenGL */
  inline bool isEnabled() const { return m_enabled; }

  /** True if shader program is set by OIV */
  inline bool isInternal() const { return m_internal; }

  static SoShaderProgramElement * getCurrentElement(SoState *);

  /** Returns TRUE if the current shader generates transparent fragments. */
  static SbBool generatesTransparency(SoState *state);

  /** Returns true is tessellation control or evaluation shader is on the state */
  static bool hasTessellationShader(SoState *state);

protected:
  // Destructor
  virtual ~SoShaderProgramElement();

  // Current shader storage
  SoRef<SoShaderProgram> m_shaderProgram ;

  /** True if shader is active */
  bool m_enabled;

  // describes if the shader program is set by the user (i.e. false) or by a
  // shader-dependent node (i.e. true, such as SoShadowGroup or SoMultipleInstance).
  bool m_internal;

};
#endif /* _SO_GL_SHADER_PROGRAM_ELEMENT_ */


