/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alan Norton (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SHAPE_STYLE_ELEMENT
#define  _SO_SHAPE_STYLE_ELEMENT

#include <Inventor/elements/SoInt32Element.h>
#include <Inventor/STL/vector>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

/**
*   Stores some information used by shapes.
* 
*  @ingroup elements
* 
*   @DESCRIPTION
*   This elements stores some information shapes need to quickly
*   determine whether or not they should render, and, if they should
*   render, how they should render. Specifically, it stores:
* 
*   NeedNormals: TRUE if lighting is on@BR
*   NeedTangents: TRUE if lighting is on@BR
*   NeedTexCoords: TRUE if texturing and texcoords not generated by GL@BR
*   MightNotRender: TRUE if:@BR
*            - bounding box complexity
*            - invisible drawstyle
*            - render abort callback registered
* 
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoShapeStyleElement : public SoElement {

  SO_ELEMENT_HEADER(SoShapeStyleElement);

 public:
 
    /** flags */
  enum flags { 
    /** INVISIBLE_BIT */
    INVISIBLE_BIT = 0x1, 
    /** BBOX_BIT */
    BBOX_BIT = 0x2, 
    /** DELAY_TRANSP_BIT */
    DELAY_TRANSP_BIT = 0x4
  };

  /** @copydoc SoElement::push() */
  virtual void push(SoState *state);

  /** @copydoc SoElement::pop() */
  virtual void pop(SoState *state, const SoElement *prevTopElement);

  /**
  *  Get a readable instance.
  */
  static const SoShapeStyleElement *  get(SoState *state);

  /**
  *  Returns TRUE if shapes may not render for some reason.
  */
  SbBool              mightNotRender() const { return m_delayFlags; }

  /**
  *  Returns TRUE if need normals.
  */
  SbBool              needNormals() const { return m_needNorms; }

  /**
   * Returns TRUE if need tangents.
   */
  SbBool needTangents() const
  {
    return m_needTangs;
  }
    
  /**
  *  Returns TRUE if need texture coordinates.
  */
  SbBool              needTexCoords(int unit=0) const;

  /**
  *  Returns TRUE if need 3D texture coordinates.
  */
  SbBool              needTexCoords3(int unit=0) const;

  /**
  *  Returns a mask that can be used by the SoVertexPropertyCache
  *  class (see SoVertexProperty.h for the SoRenderInfo class) to
  *  quickly mask out the normal or texture coordinate cases if
  *  normals or texture coordinates aren't needed.
  */
  int                 getRenderCaseMask() const
  { return m_renderCaseMask; }

  /**
  *  API used by other elements.
  */
  static void         setDrawStyle(SoState *state, int32_t value);
  /**
  *  API used by other elements.
  */
  static void         setComplexityType(SoState *state, int32_t value);
  /**
  *  API used by other elements.
  */
  static void         setTransparencyType(SoState *state, int32_t value);
  /**
  *  API used by other elements.
  */
  static void         setTextureEnabled(SoState *state, SbBool value, int unit=0);
  /**
  *  API used by other elements.
  */
  static void         setTexture3Enabled(SoState *state, SbBool value, int unit=0);
  /**
  *  API used by other elements.
  */
  static void         setTextureFunction(SoState *state, SbBool value, int unit=0);
  /**
  *  API used by other elements.
  */
  static void         setLightModel(SoState *state, int32_t value);
  /**
  *  Set value is TRUE if either diffuse, transparency, or materialbinding
  *  are overridden; otherwise FALSE.
  */
  static void         setOverrides(SoState *state, SbBool value);

  /** @copydoc SoElement::print */
  virtual void        print(FILE *fp) const;

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /** @copydoc SoElement::init() */
  virtual void init(SoState *state);

  /** @copydoc SoElement::matches() */
  virtual SbBool matches(const SoElement* elt) const;

  /** @copydoc SoElement::copyMatchInfo() */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  SbBool      isTextureFunction(int unit=0) const
  {return (getTextureData(unit).texFunc);}

  static void         initClass();

  static void         exitClass();

 protected:

  virtual             ~SoShapeStyleElement();

 private:
  int                 m_delayFlags; // True if rendering might be delayed
  SbBool              m_needNorms;
  SbBool              m_needTangs;

  // Texture Data for each texture unit
  struct SoTextureData {
    bool  texEnabled ;
    bool  tex3Enabled ;
    bool  texFunc ;

    // Constructor
    SoTextureData()
    {
      texEnabled = tex3Enabled = texFunc = false;
    }

    // equality operator
    friend int operator ==(const SoTextureData &texData1, const SoTextureData &texData2)
    { 
      return (texData1.texEnabled  == texData2.texEnabled &&
	            texData1.tex3Enabled == texData2.tex3Enabled &&
	            texData1.texFunc     == texData2.texFunc) ;
    }

    // !equality operator
    friend int operator !=(const SoTextureData &texData1, const SoTextureData &texData2)
    { return !(texData1 == texData2) ; }
  } ;
  

  SoTextureData& getTextureData( const int unit ) const;
  typedef std::vector<SoTextureData> SoTexDataList;
  mutable SoTexDataList m_texDataList;

  int                 m_renderCaseMask;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif /* _SO_SHAPE_STYLE_ELEMENT */


