/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_SHININESS_ELEMENT
#define  _SO_SHININESS_ELEMENT


#include <Inventor/elements/SoMaterialElement.h>
#include <Inventor/misc/SoState.h>
#include <Inventor/errors/SoDebugError.h>

/**
*   Stores shininess of current material (mostly superseded by SoMaterialElement).
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   Mostly superseded by SoMaterialElement.
*   get() and set() methods retained for compatibility
* 
*   @SEE_ALSO
*
* [OIV-WRAPPER-NO-WRAP]
*/

SoEXTENDER_Documented class SoDEPRECATED_CLASS(9500, "See #SoMaterialElement instead.") SoShininessElement {


 public:

  /**
  *  Sets the current shininess(es).
  */
  static void set(SoState *state, SoNode *,
                          int32_t numShininesses, const float *shininesses);

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoShininessElement * getInstance(SoState *state);

  /**
  *  Returns the number of shininess values in an instance.
  */
  int32_t getNum() const
  { return 1; }

  /**
  *  Returns the indexed shininess from an element.
  */
  float get(int index) const;

  /**
  *  Returns the default shininess.
  */
  static float        getDefault()            
    { return SoMaterialElement::getDefaultShininess(); }


 private:
  SoState * saveState;
};


inline void 
#if defined(_DEBUG)
SoShininessElement::set(SoState *state, SoNode *node, int32_t numShininesses, const float *shininesses)
#else
SoShininessElement::set(SoState *state, SoNode *node, int32_t, const float *shininesses)
#endif
{
  SoMaterialElement::setShininess(state, node,*shininesses);
#if defined(_DEBUG)
  if(numShininesses>1){
    SoDebugError::post("SoShininessElement::set",
                       "multiple shininess not supported");
  }
#endif
}


inline const SoShininessElement *
SoShininessElement::getInstance(SoState *state)
{
  SoShininessElement* se = new SoShininessElement;
  se->saveState = state;
  return(se);
}

inline float
#if defined(_DEBUG)
SoShininessElement::get(int index) const
#else
SoShininessElement::get(int) const
#endif
{
#if defined(_DEBUG)
  if(index >1)
    SoDebugError::post("SoShininessElement::get",
                       "multiple shininess values not supported");
#endif
  return(SoMaterialElement::getShininess(saveState));
}


#endif /* _SO_SHININESS_ELEMENT */

