/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Olivier Fedkiw (MMM yyyy)
**=======================================================================*/

#ifndef _SO_STEREO_ELEMENT
#define _SO_STEREO_ELEMENT

#include <Inventor/nodes/SoCamera.h>
#include <Inventor/elements/SoSubElement.h>

/**
*  @VSGEXT Stores the current stereo attributes.
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current stereo attributes.
* 
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoStereoElement : public SoElement {
  
  SO_ELEMENT_HEADER(SoStereoElement);
  
 public:  
  /**
   * Indicates if the stereo offset and and balance setting should be
   * interpreted as factors or as absolute parameters.
   * If TRUE, the stereo adjustments are absolute.
   */
  static void setStereoAbsoluteAdjustments(SoState * state, SbBool absolute);
  /**
   * Returns TRUE if stereo adjustments are absolute. See #setStereoAbsoluteAdjustments().
   */
  static bool isStereoAbsoluteAdjustments(SoState * state);

  /**
   *  Sets the stereo offset adjustment.
   */
  static void setStereoAdjustment(SoState * state, float stoffset);
 
  /** 
   *  Sets the stereo balance adjustment. When @B stNearFrac @b is set to TRUE,
   *  @B stbalance @b value is considered to be a fraction of the camera near distance.
   */
  static void setBalanceAdjustment(SoState * state, float stbalance, SbBool stNearFrac = false);

  /**
   *  Sets the inter-eye distance (immersive MP only).
   */
  static void setInterEyeDistance(SoState * state, float ied);
    
  /**
   *  Sets the stereo inverted view flag.
   */
  static void setReversedView(SoState * state, bool strev);

  /**
   *  Returns the stereo offset adjustment.
   */
  static float getStereoAdjustment(SoState *state); 
  
  /**
   *  Returns the stereo balance adjustment.
   */
  static float getBalanceAdjustment(SoState *state);

  /** 
   * Returns TRUE when the stereo balance adjustement is defined as a fraction
   * of the camera near distance.  See setBalanceAdjustment.
   */
  static SbBool isBalanceAdjustmentNearFrac(SoState *state);

  /**
   *  Returns the inter-eye distance (immersive MP only).
   */
  static float getInterEyeDistance(SoState *state);
  
  /**
   *  Returns the inverted view flag.
   */
  static bool getReversedView(SoState *state);
  
  /**
   *  Sets the stereo mode, LEFT_VIEW, RIGHT_VIEW, or MONOSCOPIC.
   */
  static void set(SoState *state, const SoCamera::StereoMode mode);
  
  // Returns the boolean that tells the camera to narrow or not the view volume
  //static const SbBool getNarrow(SoState *state);
  
  /**
   *  Returns the stereoMode.
   */
  static SoCamera::StereoMode getStereoMode(SoState *state);
  
  /**
   *  Return the top (current) instance of the element in the state.
   *  Note it does NOT cause cache dependency!
   *  It also casts away the const.
   */
  static SoStereoElement *getInstance(const SoState *state, SbBool &elemIsSet);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
   *  Returns TRUE if the passes match in both elements.
   */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
   // Initializes the SoStereoElement class
  static void initClass();
  static void exitClass();

protected:
  
  SoCamera::StereoMode stereoMode;
  SbBool stereoAbsoluteAdjustments;
  float stereoOffset;
  bool stereoNearFrac;
  float stereoBalance;
  float interEyeDistance;
  bool reversed;
  SbBool isSet;
  
  virtual ~SoStereoElement();

  friend class SoGuiRenderArea;
  friend class SoBaseStereo;
  friend class SoStereoCamera;
};
#endif /* _SO_STEREO_ELEMENT */


