/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Aug 2009)
**=======================================================================*/

#ifndef  _SO_TEXT_ALIASING_FACTOR_ELEMENT_
#define  _SO_TEXT_ALIASING_FACTOR_ELEMENT_

#include <Inventor/elements/SoFloatElement.h>

/**
*  @VSGEXT Stores the current textured text anti-aliasing factor.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current textured text anti-aliasing factor.
*
*   @SEE_ALSO
*   SoTextProperty
*/
SoEXTENDER_Documented class INVENTOR_API SoTextAliasingFactorElement : public SoFloatElement
{

  SO_ELEMENT_HEADER(SoTextAliasingFactorElement);

 public:

   /**
   *  Sets the current horizontal text alignment in the state.
   */
   static void set(SoState *state, float factor);

   /**
   *  Sets the current horizontal text alignment in the state.
   */
  static void set(SoState* state, SoNode*, float style) { set(state, style); }

  /**
  *  Returns current draw style from the state.
  */
  static float get(SoState* state) { return SoFloatElement::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default draw style.
  */
  static float getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:

  // Initializes the SoTextAliasingFactorElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoTextAliasingFactorElement();

 private:
  static float s_defaultAliasingFactor;
  static bool s_isSet;
};

#endif // _SO_TEXT_ALIASING_FACTOR_ELEMENT_

/**/


